/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzl;
import java.util.concurrent.TimeUnit;

public class DataUpdateNotification
extends AbstractSafeParcelable {
    public static final String ACTION = "com.google.android.gms.fitness.DATA_UPDATE_NOTIFICATION";
    public static final int OPERATION_INSERT = 1;
    public static final int OPERATION_DELETE = 2;
    public static final int OPERATION_UPDATE = 3;
    public static final String EXTRA_DATA_UPDATE_NOTIFICATION = "vnd.google.fitness.data_udpate_notification";
    final int mVersionCode;
    private final long PI;
    private final long PJ;
    private final int PK;
    private final DataSource ON;
    private final DataType OM;
    public static final Parcelable.Creator<DataUpdateNotification> CREATOR = new zzl();

    DataUpdateNotification(int n, long l, long l2, int n2, DataSource dataSource, DataType dataType) {
        this.mVersionCode = n;
        this.PI = l;
        this.PJ = l2;
        this.PK = n2;
        this.ON = dataSource;
        this.OM = dataType;
    }

    public static DataUpdateNotification getDataUpdateNotification(Intent intent) {
        return (DataUpdateNotification)zzc.zza((Intent)intent, (String)EXTRA_DATA_UPDATE_NOTIFICATION, CREATOR);
    }

    public long zzber() {
        return this.PI;
    }

    public long zzbes() {
        return this.PJ;
    }

    public long getUpdateStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.PI, TimeUnit.NANOSECONDS);
    }

    public long getUpdateEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.PJ, TimeUnit.NANOSECONDS);
    }

    public int getOperationType() {
        return this.PK;
    }

    public DataSource getDataSource() {
        return this.ON;
    }

    public DataType getDataType() {
        return this.OM;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataUpdateNotification && this.zza((DataUpdateNotification)((Object)object));
    }

    private boolean zza(DataUpdateNotification dataUpdateNotification) {
        return this.PI == dataUpdateNotification.PI && this.PJ == dataUpdateNotification.PJ && this.PK == dataUpdateNotification.PK && zzab.equal((Object)((Object)this.ON), (Object)((Object)dataUpdateNotification.ON)) && zzab.equal((Object)((Object)this.OM), (Object)((Object)dataUpdateNotification.OM));
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.PI, this.PJ, this.PK, this.ON, this.OM});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("updateStartTimeNanos", (Object)this.PI).zzg("updateEndTimeNanos", (Object)this.PJ).zzg("operationType", (Object)this.PK).zzg("dataSource", (Object)this.ON).zzg("dataType", (Object)this.OM).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzl.zza(this, parcel, n);
    }
}

