/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzi;

public class DataSource
extends AbstractSafeParcelable {
    private static final int[] Pp = new int[0];
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int versionCode;
    private final DataType Pl;
    private final String name;
    private final int type;
    private final Device Pq;
    private final Application Pr;
    private final String Ps;
    private final int[] Pt;
    private final String Pu;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzi();

    DataSource(int n, DataType dataType, String string, int n2, Device device, Application application, String string2, int[] nArray) {
        this.versionCode = n;
        this.Pl = dataType;
        this.type = n2;
        this.name = string;
        this.Pq = device;
        this.Pr = application;
        this.Ps = string2;
        this.Pu = this.zzbep();
        this.Pt = nArray != null ? nArray : Pp;
    }

    private DataSource(Builder builder) {
        this.versionCode = 3;
        this.Pl = builder.Pl;
        this.type = builder.type;
        this.name = builder.name;
        this.Pq = builder.Pq;
        this.Pr = builder.Pr;
        this.Ps = builder.Ps;
        this.Pu = this.zzbep();
        this.Pt = Builder.zzg(builder);
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzc.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.Pl;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getAppPackageName() {
        return this.Pr == null ? null : this.Pr.getPackageName();
    }

    public Application zzben() {
        return this.Pr;
    }

    public Device getDevice() {
        return this.Pq;
    }

    public String getStreamName() {
        return this.Ps;
    }

    public int[] zzbeo() {
        return this.Pt;
    }

    public String getStreamIdentifier() {
        return this.Pu;
    }

    private String zzbep() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.Pl.getName());
        if (this.Pr != null) {
            stringBuilder.append(":").append(this.Pr.getPackageName());
        }
        if (this.Pq != null) {
            stringBuilder.append(":").append(this.Pq.getStreamIdentifier());
        }
        if (this.Ps != null) {
            stringBuilder.append(":").append(this.Ps);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataSource && this.zza((DataSource)((Object)object));
    }

    private boolean zza(DataSource dataSource) {
        return this.Pu.equals(dataSource.Pu);
    }

    public int hashCode() {
        return this.Pu.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.name != null) {
            stringBuilder.append(":").append(this.name);
        }
        if (this.Pr != null) {
            stringBuilder.append(":").append((Object)this.Pr);
        }
        if (this.Pq != null) {
            stringBuilder.append(":").append((Object)this.Pq);
        }
        if (this.Ps != null) {
            stringBuilder.append(":").append(this.Ps);
        }
        stringBuilder.append(":").append((Object)this.Pl);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = String.valueOf(DataSource.zznx(this.type));
        String string8 = String.valueOf(this.Pl.zzbeq());
        if (this.Pr == null) {
            string6 = "";
        } else if (this.Pr.equals((Object)Application.OT)) {
            string6 = ":gms";
        } else {
            String string9 = String.valueOf(this.Pr.getPackageName());
            string6 = string5 = string9.length() != 0 ? ":".concat(string9) : new String(":");
        }
        if (this.Pq != null) {
            string4 = String.valueOf(this.Pq.getModel());
            string3 = String.valueOf(this.Pq.getUid());
            string2 = new StringBuilder(2 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(":").append(string4).append(":").append(string3).toString();
        } else {
            string2 = string4 = "";
        }
        if (this.Ps != null) {
            String string10 = String.valueOf(this.Ps);
            string = string10.length() != 0 ? ":".concat(string10) : new String(":");
        } else {
            string = "";
        }
        string3 = string;
        return new StringBuilder(1 + String.valueOf(string7).length() + String.valueOf(string8).length() + String.valueOf(string5).length() + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string7).append(":").append(string8).append(string5).append(string4).append(string3).toString();
    }

    public static String zznx(int n) {
        switch (n) {
            case 0: {
                return "r";
            }
            case 1: {
                return "d";
            }
            case 2: {
                return "c";
            }
            case 3: {
                return "v";
            }
        }
        throw new IllegalArgumentException(new StringBuilder(29).append("invalid type value").append(n).toString());
    }

    public static String zzny(int n) {
        switch (n) {
            case 1: {
                return "blood_pressure_esh2002";
            }
            case 2: {
                return "blood_pressure_esh2010";
            }
            case 3: {
                return "blood_pressure_aami";
            }
            case 4: {
                return "blood_pressure_bhs_a_a";
            }
            case 5: {
                return "blood_pressure_bhs_a_b";
            }
            case 6: {
                return "blood_pressure_bhs_b_a";
            }
            case 7: {
                return "blood_pressure_bhs_b_b";
            }
            case 8: {
                return "blood_glucose_iso151972003";
            }
            case 9: {
                return "blood_glucose_iso151972013";
            }
        }
        throw new IllegalArgumentException(new StringBuilder(47).append("invalid data quality standard value ").append(n).toString());
    }

    private String getTypeString() {
        switch (this.type) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
            case 2: {
                return "cleaned";
            }
            case 3: {
                return "converted";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    int getVersionCode() {
        return this.versionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }

    public static final class Builder {
        private DataType Pl;
        private int type = -1;
        private String name;
        private Device Pq;
        private Application Pr;
        private String Ps = "";

        public Builder setDataType(DataType dataType) {
            this.Pl = dataType;
            return this;
        }

        public Builder setType(int n) {
            this.type = n;
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setDevice(Device device) {
            this.Pq = device;
            return this;
        }

        public Builder setAppPackageName(String string) {
            this.Pr = Application.zzjf(string);
            return this;
        }

        public Builder setAppPackageName(Context context) {
            return this.setAppPackageName(context.getPackageName());
        }

        public Builder setStreamName(String string) {
            zzac.zzb((string != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.Ps = string;
            return this;
        }

        public DataSource build() {
            zzac.zza((this.Pl != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzac.zza((this.type >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }

        static /* synthetic */ int[] zzg(Builder builder) {
            return null;
        }
    }
}

