/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zze;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zztd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
extends AbstractSafeParcelable {
    private final int versionCode;
    private final DataSource Pe;
    private final DataType Pl;
    private final List<DataPoint> Pm;
    private final List<DataSource> Pn;
    private boolean Po = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zzh();

    DataSet(int n, DataSource dataSource, DataType dataType, List<RawDataPoint> list, List<DataSource> list2, boolean bl) {
        this.versionCode = n;
        this.Pe = dataSource;
        this.Pl = dataSource.getDataType();
        this.Po = bl;
        this.Pm = new ArrayList<DataPoint>(list.size());
        this.Pn = n >= 2 ? list2 : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : list) {
            this.Pm.add(new DataPoint(this.Pn, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.versionCode = 3;
        this.Pe = (DataSource)((Object)zzac.zzy((Object)((Object)dataSource)));
        this.Pl = dataSource.getDataType();
        this.Pm = new ArrayList<DataPoint>();
        this.Pn = new ArrayList<DataSource>();
        this.Pn.add(this.Pe);
    }

    public DataSet(RawDataSet rawDataSet, List<DataSource> list) {
        this.versionCode = 3;
        this.Pe = DataSet.zzd(list, rawDataSet.Rx);
        this.Pl = this.Pe.getDataType();
        this.Pn = list;
        this.Po = rawDataSet.Pb;
        List<RawDataPoint> list2 = rawDataSet.RC;
        this.Pm = new ArrayList<DataPoint>(list2.size());
        for (RawDataPoint rawDataPoint : list2) {
            this.Pm.add(new DataPoint(this.Pn, rawDataPoint));
        }
    }

    private static <T> T zzd(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzac.zzb((Object)((Object)dataSource), (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.Pe);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzac.zzb((boolean)dataSource.getStreamIdentifier().equals(this.Pe.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.Pe});
        dataPoint.zzbej();
        DataSet.zze(dataPoint);
        this.zzd(dataPoint);
    }

    public void zzd(DataPoint dataPoint) {
        this.Pm.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.Pn.contains((Object)dataSource)) {
            this.Pn.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzd(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.Pe;
    }

    public DataType getDataType() {
        return this.Pe.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.Pm);
    }

    public boolean isEmpty() {
        return this.Pm.isEmpty();
    }

    public boolean zzbec() {
        return this.Po;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataSet && this.zza((DataSet)((Object)object));
    }

    private boolean zza(DataSet dataSet) {
        return zzab.equal((Object)((Object)this.getDataType()), (Object)((Object)dataSet.getDataType())) && zzab.equal((Object)((Object)this.Pe), (Object)((Object)dataSet.Pe)) && zzab.equal(this.Pm, dataSet.Pm) && this.Po == dataSet.Po;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.Pe});
    }

    public String toString() {
        List<RawDataPoint> list = this.zzbel();
        return String.format("DataSet{%s %s}", this.Pe.toDebugString(), this.Pm.size() < 10 ? list : String.format("%d data points, first 5: %s", this.Pm.size(), list.subList(0, 5)));
    }

    public static void zze(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zztd.zza(dataPoint, zze.Pc);
        if (string != null) {
            String string2 = String.valueOf((Object)dataPoint);
            Log.w((String)"Fitness", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Invalid data point: ").append(string2).toString());
            throw new IllegalArgumentException(string);
        }
    }

    int getVersionCode() {
        return this.versionCode;
    }

    List<RawDataPoint> zzbel() {
        return this.zzaa(this.Pn);
    }

    List<RawDataPoint> zzaa(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.Pm.size());
        for (DataPoint dataPoint : this.Pm) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zzbem() {
        return this.Pn;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }
}

