/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzg;
import com.google.android.gms.internal.zzsx;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
extends AbstractSafeParcelable {
    private final int versionCode;
    private final DataSource Pe;
    private long Pf;
    private long Pg;
    private final Value[] Ph;
    private DataSource Pi;
    private long Pj;
    private long Pk;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzg();

    DataPoint(int n, DataSource dataSource, long l, long l2, Value[] valueArray, DataSource dataSource2, long l3, long l4) {
        this.versionCode = n;
        this.Pe = dataSource;
        this.Pi = dataSource2;
        this.Pf = l;
        this.Pg = l2;
        this.Ph = valueArray;
        this.Pj = l3;
        this.Pk = l4;
    }

    DataPoint(List<DataSource> list, RawDataPoint rawDataPoint) {
        this(DataPoint.zzc(list, rawDataPoint.Rx), DataPoint.zzc(list, rawDataPoint.Ry), rawDataPoint);
    }

    public DataPoint(DataSource dataSource, DataSource dataSource2, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.Ru, 0L), DataPoint.zza(rawDataPoint.Rv, 0L), rawDataPoint.Rw, dataSource2, DataPoint.zza(rawDataPoint.Rz, 0L), DataPoint.zza(rawDataPoint.RA, 0L));
    }

    private static DataSource zzc(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.versionCode = 4;
        this.Pe = (DataSource)((Object)zzac.zzb((Object)((Object)dataSource), (Object)"Data source cannot be null"));
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.Ph = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.Ph[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzc.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long l, TimeUnit timeUnit) {
        this.Pf = timeUnit.toNanos(l);
        if (this.zzbee() && zzsx.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.Pf = zzsx.zza(this.Pf, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zzbee() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long l, long l2, TimeUnit timeUnit) {
        this.Pg = timeUnit.toNanos(l);
        this.Pf = timeUnit.toNanos(l2);
        return this;
    }

    public Value zznt(int n) {
        DataType dataType = this.getDataType();
        if (n < 0 || n >= dataType.getFields().size()) {
            throw new IllegalArgumentException(String.format("fieldIndex %s is out of range for %s", new Object[]{n, dataType}));
        }
        return this.Ph[n];
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.Ph[n];
    }

    public Value[] zzbef() {
        return this.Ph;
    }

    public DataPoint setFloatValues(float ... fArray) {
        this.zznu(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.Ph[i].setFloat(fArray[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... nArray) {
        this.zznu(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.Ph[i].setInt(nArray[i]);
        }
        return this;
    }

    private void zznu(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzac.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public DataType getDataType() {
        return this.Pe.getDataType();
    }

    public DataSource getDataSource() {
        return this.Pe;
    }

    public DataSource getOriginalDataSource() {
        return this.Pi != null ? this.Pi : this.Pe;
    }

    public DataSource zzbeg() {
        return this.Pi;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.Pf, TimeUnit.NANOSECONDS);
    }

    public long zzbeh() {
        return this.Pj;
    }

    public long zzbei() {
        return this.Pk;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.Pg, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.Pf, TimeUnit.NANOSECONDS);
    }

    public void zzbej() {
        DataSource dataSource = this.getDataSource();
        zzac.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzac.zzb((this.Pf > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzac.zzb((this.Pg <= this.Pf ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataPoint && this.zzc((DataPoint)((Object)object));
    }

    private boolean zzc(DataPoint dataPoint) {
        return zzab.equal((Object)((Object)this.Pe), (Object)((Object)dataPoint.Pe)) && this.Pf == dataPoint.Pf && this.Pg == dataPoint.Pg && Arrays.equals((Object[])this.Ph, (Object[])dataPoint.Ph) && zzab.equal((Object)((Object)this.getOriginalDataSource()), (Object)((Object)dataPoint.getOriginalDataSource()));
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.Pe, this.Pf, this.Pg});
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString((Object[])this.Ph), this.Pg, this.Pf, this.Pj, this.Pk, this.Pe.toDebugString(), this.Pi != null ? this.Pi.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public long getTimestampNanos() {
        return this.Pf;
    }

    public long zzbek() {
        return this.Pg;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzg.zza(this, parcel, n);
    }

    private static long zza(Long l, long l2) {
        return l != null ? l : l2;
    }
}

