/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzd;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
extends AbstractSafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int mVersionCode;
    private final long bZ;
    private final long GX;
    private final Session OP;
    private final int OY;
    private final List<DataSet> OZ;
    private final int Pa;
    private boolean Pb = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zzd();

    Bucket(int n, long l, long l2, Session session, int n2, List<DataSet> list, int n3, boolean bl) {
        this.mVersionCode = n;
        this.bZ = l;
        this.GX = l2;
        this.OP = session;
        this.OY = n2;
        this.OZ = list;
        this.Pa = n3;
        this.Pb = bl;
    }

    public Bucket(RawBucket rawBucket, List<DataSource> list) {
        this(2, rawBucket.bZ, rawBucket.GX, rawBucket.OP, rawBucket.Rt, Bucket.zza(rawBucket.OZ, list), rawBucket.Pa, rawBucket.Pb);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.bZ, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.GX, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.OP;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.OY);
    }

    public int zzbeb() {
        return this.OY;
    }

    public List<DataSet> getDataSets() {
        return this.OZ;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.OZ) {
            if (!dataSet.getDataType().equals((Object)dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.Pa;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Bucket && this.zza((Bucket)((Object)object));
    }

    private boolean zza(Bucket bucket) {
        return this.bZ == bucket.bZ && this.GX == bucket.GX && this.OY == bucket.OY && zzab.equal(this.OZ, bucket.OZ) && this.Pa == bucket.Pa && this.Pb == bucket.Pb;
    }

    public boolean zzb(Bucket bucket) {
        return this.bZ == bucket.bZ && this.GX == bucket.GX && this.OY == bucket.OY && this.Pa == bucket.Pa;
    }

    public boolean zzbec() {
        if (this.Pb) {
            return true;
        }
        for (DataSet dataSet : this.OZ) {
            if (!dataSet.zzbec()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.bZ, this.GX, this.OY, this.Pa});
    }

    public String toString() {
        return zzab.zzx((Object)((Object)this)).zzg("startTime", (Object)this.bZ).zzg("endTime", (Object)this.GX).zzg("activity", (Object)this.OY).zzg("dataSets", this.OZ).zzg("bucketType", (Object)Bucket.zznr(this.Pa)).zzg("serverHasMoreData", (Object)this.Pb).toString();
    }

    public static String zznr(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzafn() {
        return this.bZ;
    }

    public long zzbao() {
        return this.GX;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }
}

