/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationStatusCodes;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzh;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.internal.zzj;
import com.google.android.gms.location.internal.zzk;
import java.util.List;

public class zzl
extends com.google.android.gms.location.internal.zzb {
    private final zzk aid;

    public zzl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, com.google.android.gms.common.internal.zzh.zzcd((Context)context));
    }

    public zzl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, com.google.android.gms.common.internal.zzh zzh2) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzh2);
        this.aid = new zzk(context, this.ahK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzk zzk2 = this.aid;
        synchronized (zzk2) {
            if (this.isConnected()) {
                try {
                    this.aid.removeAllListeners();
                    this.aid.zzbpm();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
        }
    }

    public void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zzatw();
        zzac.zzy((Object)pendingIntent);
        zzac.zzb((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzi)this.zzatx()).zza(l, true, pendingIntent);
    }

    public void zzb(PendingIntent pendingIntent) throws RemoteException {
        this.zzatw();
        zzac.zzy((Object)pendingIntent);
        ((zzi)this.zzatx()).zzb(pendingIntent);
    }

    public void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zzqc.zzb<Status> zzb2) throws RemoteException {
        this.zzatw();
        zzac.zzb((Object)((Object)geofencingRequest), (Object)"geofencingRequest can't be null.");
        zzac.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzac.zzb(zzb2, (Object)"ResultHolder not provided.");
        zza zza2 = new zza(zzb2);
        ((zzi)this.zzatx()).zza(geofencingRequest, pendingIntent, zza2);
    }

    public void zza(PendingIntent pendingIntent, zzqc.zzb<Status> zzb2) throws RemoteException {
        this.zzatw();
        zzac.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzac.zzb(zzb2, (Object)"ResultHolder not provided.");
        zzb zzb3 = new zzb(zzb2);
        ((zzi)this.zzatx()).zza(pendingIntent, (zzh)zzb3, this.getContext().getPackageName());
    }

    public void zza(List<String> list, zzqc.zzb<Status> zzb2) throws RemoteException {
        this.zzatw();
        zzac.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"geofenceRequestIds can't be null nor empty.");
        zzac.zzb(zzb2, (Object)"ResultHolder not provided.");
        String[] stringArray = list.toArray(new String[0]);
        zzb zzb3 = new zzb(zzb2);
        ((zzi)this.zzatx()).zza(stringArray, (zzh)zzb3, this.getContext().getPackageName());
    }

    public Location getLastLocation() {
        return this.aid.getLastLocation();
    }

    public LocationAvailability zzbpl() {
        return this.aid.zzbpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper, zzg zzg2) throws RemoteException {
        zzk zzk2 = this.aid;
        synchronized (zzk2) {
            this.aid.zza(locationRequestInternal, locationCallback, looper, zzg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper, zzg zzg2) throws RemoteException {
        zzk zzk2 = this.aid;
        synchronized (zzk2) {
            this.aid.zza(locationRequest, locationListener, looper, zzg2);
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.aid.zza(locationRequest, pendingIntent, zzg2);
    }

    public void zza(LocationListener locationListener, zzg zzg2) throws RemoteException {
        this.aid.zza(locationListener, zzg2);
    }

    public void zza(PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.aid.zza(pendingIntent, zzg2);
    }

    public void zza(LocationCallback locationCallback, zzg zzg2) throws RemoteException {
        this.aid.zza(locationCallback, zzg2);
    }

    public void zzcc(boolean bl) throws RemoteException {
        this.aid.zzcc(bl);
    }

    public void zzd(Location location) throws RemoteException {
        this.aid.zzd(location);
    }

    public void zza(zzg zzg2) throws RemoteException {
        this.aid.zza(zzg2);
    }

    public void zza(LocationSettingsRequest locationSettingsRequest, zzqc.zzb<LocationSettingsResult> zzb2, String string) throws RemoteException {
        this.zzatw();
        zzac.zzb((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzac.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzc zzc2 = new zzc(zzb2);
        ((zzi)this.zzatx()).zza(locationSettingsRequest, zzc2, string);
    }

    private static final class zzc
    extends zzj.zza {
        private zzqc.zzb<LocationSettingsResult> aie;

        public zzc(zzqc.zzb<LocationSettingsResult> zzb2) {
            zzac.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
            this.aie = zzb2;
        }

        @Override
        public void zza(LocationSettingsResult locationSettingsResult) throws RemoteException {
            this.aie.setResult((Object)locationSettingsResult);
            this.aie = null;
        }
    }

    private static final class zzb
    extends zzh.zza {
        private zzqc.zzb<Status> aie;

        public zzb(zzqc.zzb<Status> zzb2) {
            this.aie = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onAddGeofencesResult");
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            this.zzun(n);
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            this.zzun(n);
        }

        private void zzun(int n) {
            if (this.aie == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzuk(LocationStatusCodes.zzuj(n));
            this.aie.setResult((Object)status);
            this.aie = null;
        }
    }

    private static final class zza
    extends zzh.zza {
        private zzqc.zzb<Status> aie;

        public zza(zzqc.zzb<Status> zzb2) {
            this.aie = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            if (this.aie == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzuk(LocationStatusCodes.zzuj(n));
            this.aie.setResult((Object)status);
            this.aie = null;
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByRequestIdsResult");
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByPendingIntentResult");
        }
    }
}

