/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.LocationRequestUpdateData;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.internal.zzp;
import com.google.android.gms.location.zzf;
import com.google.android.gms.location.zzg;
import java.util.HashMap;
import java.util.Map;

public class zzk {
    private final zzp<zzi> ahK;
    private final Context mContext;
    private ContentProviderClient ahX = null;
    private boolean ahY = false;
    private Map<LocationListener, zzc> Tx = new HashMap<LocationListener, zzc>();
    private Map<LocationCallback, zza> ahZ = new HashMap<LocationCallback, zza>();

    public zzk(Context context, zzp<zzi> zzp2) {
        this.mContext = context;
        this.ahK = zzp2;
    }

    public Location getLastLocation() {
        this.ahK.zzatw();
        try {
            Location location = this.ahK.zzatx().zzkx(this.mContext.getPackageName());
            return location;
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public LocationAvailability zzbpl() {
        this.ahK.zzatw();
        try {
            return this.ahK.zzatx().zzky(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper, zzg zzg2) throws RemoteException {
        this.ahK.zzatw();
        zzc zzc2 = this.zza(locationListener, looper);
        this.ahK.zzatx().zza(LocationRequestUpdateData.zza(LocationRequestInternal.zzb(locationRequest), zzc2, zzg2));
    }

    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper, zzg zzg2) throws RemoteException {
        this.ahK.zzatw();
        zza zza2 = this.zza(locationCallback, looper);
        this.ahK.zzatx().zza(LocationRequestUpdateData.zza(locationRequestInternal, zza2, zzg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zza(LocationListener locationListener, Looper looper) {
        Map<LocationListener, zzc> map = this.Tx;
        synchronized (map) {
            zzc zzc2 = this.Tx.get(locationListener);
            if (zzc2 == null) {
                zzc2 = new zzc(locationListener, looper);
            }
            this.Tx.put(locationListener, zzc2);
            return zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zza zza(LocationCallback locationCallback, Looper looper) {
        Map<LocationCallback, zza> map = this.ahZ;
        synchronized (map) {
            zza zza2 = this.ahZ.get(locationCallback);
            if (zza2 == null) {
                zza2 = new zza(locationCallback, looper);
            }
            this.ahZ.put(locationCallback, zza2);
            return zza2;
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.ahK.zzatw();
        this.ahK.zzatx().zza(LocationRequestUpdateData.zza(LocationRequestInternal.zzb(locationRequest), pendingIntent, zzg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationListener locationListener, zzg zzg2) throws RemoteException {
        this.ahK.zzatw();
        zzac.zzb((Object)locationListener, (Object)"Invalid null listener");
        Map<LocationListener, zzc> map = this.Tx;
        synchronized (map) {
            zzc zzc2 = this.Tx.remove(locationListener);
            if (zzc2 != null) {
                zzc2.release();
                this.ahK.zzatx().zza(LocationRequestUpdateData.zza(zzc2, zzg2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationCallback locationCallback, zzg zzg2) throws RemoteException {
        this.ahK.zzatw();
        zzac.zzb((Object)locationCallback, (Object)"Invalid null callback");
        Map<LocationCallback, zza> map = this.ahZ;
        synchronized (map) {
            zza zza2 = this.ahZ.remove(locationCallback);
            if (zza2 != null) {
                zza2.release();
                this.ahK.zzatx().zza(LocationRequestUpdateData.zza(zza2, zzg2));
            }
        }
    }

    public void zza(PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.ahK.zzatw();
        this.ahK.zzatx().zza(LocationRequestUpdateData.zzb(pendingIntent, zzg2));
    }

    public void zzcc(boolean bl) throws RemoteException {
        this.ahK.zzatw();
        this.ahK.zzatx().zzcc(bl);
        this.ahY = bl;
    }

    public void zzd(Location location) throws RemoteException {
        this.ahK.zzatw();
        this.ahK.zzatx().zzd(location);
    }

    public void zza(zzg zzg2) throws RemoteException {
        this.ahK.zzatw();
        this.ahK.zzatx().zza(zzg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            Map<Object, Binder> map = this.Tx;
            synchronized (map) {
                for (zzc binder : this.Tx.values()) {
                    if (binder == null) continue;
                    this.ahK.zzatx().zza(LocationRequestUpdateData.zza(binder, null));
                }
                this.Tx.clear();
            }
            map = this.ahZ;
            synchronized (map) {
                for (zza zza2 : this.ahZ.values()) {
                    if (zza2 == null) continue;
                    this.ahK.zzatx().zza(LocationRequestUpdateData.zza(zza2, null));
                }
                this.ahZ.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zzbpm() {
        if (this.ahY) {
            try {
                this.zzcc(false);
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    private static class zzb
    extends Handler {
        private final LocationListener aic;

        public zzb(LocationListener locationListener) {
            this.aic = locationListener;
        }

        public zzb(LocationListener locationListener, Looper looper) {
            super(looper);
            this.aic = locationListener;
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Location location = new Location((Location)message.obj);
                    this.aic.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class zza
    extends zzf.zza {
        private Handler aia;

        zza(final LocationCallback locationCallback, Looper looper) {
            if (looper == null) {
                looper = Looper.myLooper();
                zzac.zza((looper != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.aia = new Handler(looper){

                public void handleMessage(Message message) {
                    switch (message.what) {
                        case 0: {
                            locationCallback.onLocationResult((LocationResult)((Object)message.obj));
                            break;
                        }
                        case 1: {
                            locationCallback.onLocationAvailability((LocationAvailability)((Object)message.obj));
                        }
                    }
                }
            };
        }

        @Override
        public void onLocationResult(LocationResult locationResult) {
            this.zzb(0, (Object)locationResult);
        }

        @Override
        public void onLocationAvailability(LocationAvailability locationAvailability) {
            this.zzb(1, (Object)locationAvailability);
        }

        public synchronized void release() {
            this.aia = null;
        }

        private synchronized void zzb(int n, Object object) {
            if (this.aia == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a data in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = n;
            message.obj = object;
            this.aia.sendMessage(message);
        }
    }

    private static class zzc
    extends zzg.zza {
        private Handler aia;

        zzc(LocationListener locationListener, Looper looper) {
            if (looper == null) {
                zzac.zza((Looper.myLooper() != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.aia = looper == null ? new zzb(locationListener) : new zzb(locationListener, looper);
        }

        @Override
        public synchronized void onLocationChanged(Location location) {
            if (this.aia == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.aia.sendMessage(message);
        }

        public synchronized void release() {
            this.aia = null;
        }
    }
}

