/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.annotation.SuppressLint;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.zzo;
import java.util.Locale;

public class ParcelableGeofence
extends AbstractSafeParcelable
implements Geofence {
    private final int mVersionCode;
    private final String zzcaj;
    private final long ain;
    private final short agV;
    private final double agW;
    private final double agX;
    private final float agY;
    private final int agT;
    private final int agZ;
    private final int aha;
    public static final zzo CREATOR = new zzo();

    public ParcelableGeofence(int n, String string, int n2, short s, double d, double d2, float f, long l, int n3, int n4) {
        ParcelableGeofence.zzkz(string);
        ParcelableGeofence.zzf(f);
        ParcelableGeofence.zza(d, d2);
        n2 = ParcelableGeofence.zzuq(n2);
        this.mVersionCode = n;
        this.agV = s;
        this.zzcaj = string;
        this.agW = d;
        this.agX = d2;
        this.agY = f;
        this.ain = l;
        this.agT = n2;
        this.agZ = n3;
        this.aha = n4;
    }

    public ParcelableGeofence(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        this(1, string, n, s, d, d2, f, l, n2, n3);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public short zzbpq() {
        return this.agV;
    }

    public double getLatitude() {
        return this.agW;
    }

    public double getLongitude() {
        return this.agX;
    }

    public float getRadius() {
        return this.agY;
    }

    @Override
    public String getRequestId() {
        return this.zzcaj;
    }

    public long getExpirationTime() {
        return this.ain;
    }

    public int zzbpr() {
        return this.agT;
    }

    public int zzbps() {
        return this.agZ;
    }

    public int zzbpt() {
        return this.aha;
    }

    private static void zzkz(String string) {
        if (string == null || string.length() > 100) {
            String string2 = String.valueOf(string);
            throw new IllegalArgumentException(string2.length() != 0 ? "requestId is null or too long: ".concat(string2) : new String("requestId is null or too long: "));
        }
    }

    private static void zzf(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f).toString());
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d).toString());
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d2).toString());
        }
    }

    private static int zzuq(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n).toString());
        }
        return n2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzo.zza(this, parcel, n);
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String zzur(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static ParcelableGeofence zzv(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return parcelableGeofence;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", ParcelableGeofence.zzur(this.agV), this.zzcaj, this.agT, this.agW, this.agX, Float.valueOf(this.agY), this.agZ / 1000, this.aha, this.ain);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.agW);
        n2 = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.agX);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        n2 = 31 * n2 + Float.floatToIntBits(this.agY);
        n2 = 31 * n2 + this.agV;
        n2 = 31 * n2 + this.agT;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ParcelableGeofence)) {
            return false;
        }
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)object;
        if (this.agY != parcelableGeofence.agY) {
            return false;
        }
        if (this.agW != parcelableGeofence.agW) {
            return false;
        }
        if (this.agX != parcelableGeofence.agX) {
            return false;
        }
        return this.agV == parcelableGeofence.agV;
    }
}

