/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int mVersionCode;
    int mPriority;
    long ahp;
    long ahq;
    boolean TN;
    long agU;
    int ahr;
    float ahs;
    long aht;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mVersionCode = 1;
        this.mPriority = 102;
        this.ahp = 3600000L;
        this.ahq = 600000L;
        this.TN = false;
        this.agU = Long.MAX_VALUE;
        this.ahr = Integer.MAX_VALUE;
        this.ahs = 0.0f;
        this.aht = 0L;
    }

    public LocationRequest setPriority(int n) {
        LocationRequest.zzud(n);
        this.mPriority = n;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long l) {
        LocationRequest.zzau(l);
        this.ahp = l;
        if (!this.TN) {
            this.ahq = (long)((double)this.ahp / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.ahp;
    }

    public LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzau(l);
        this.aht = l;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.aht;
        if (l < this.ahp) {
            l = this.ahp;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long l) {
        LocationRequest.zzau(l);
        this.TN = true;
        this.ahq = l;
        return this;
    }

    public long getFastestInterval() {
        return this.ahq;
    }

    public LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.agU = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.agU < 0L) {
            this.agU = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long l) {
        this.agU = l;
        if (this.agU < 0L) {
            this.agU = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.agU;
    }

    public LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.ahr = n;
        return this;
    }

    public int getNumUpdates() {
        return this.ahr;
    }

    public LocationRequest setSmallestDisplacement(float f) {
        LocationRequest.zze(f);
        this.ahs = f;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.ahs;
    }

    private static void zzau(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    private static void zzud(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
    }

    private static void zze(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
    }

    LocationRequest(int n, int n2, long l, long l2, boolean bl, long l3, int n3, float f, long l4) {
        this.mVersionCode = n;
        this.mPriority = n2;
        this.ahp = l;
        this.ahq = l2;
        this.TN = bl;
        this.agU = l3;
        this.ahr = n3;
        this.ahs = f;
        this.aht = l4;
    }

    public void writeToParcel(Parcel parcel, int n) {
        LocationRequestCreator.zza(this, parcel, n);
    }

    public static String zzue(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzue(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.ahp).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.ahq).append("ms");
        if (this.aht > this.ahp) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.aht).append("ms");
        }
        if (this.agU != Long.MAX_VALUE) {
            long l = this.agU - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.ahr != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.ahr);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.mPriority, this.ahp, this.ahq, this.TN, this.agU, this.ahr, Float.valueOf(this.ahs)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.ahp == locationRequest.ahp && this.ahq == locationRequest.ahq && this.TN == locationRequest.TN && this.agU == locationRequest.agU && this.ahr == locationRequest.ahr && this.ahs == locationRequest.ahs;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }
}

