/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.location.LocationAvailabilityCreator;

public final class LocationAvailability
extends AbstractSafeParcelable
implements ReflectedParcelable {
    private final int mVersionCode;
    int ahl;
    int ahm;
    long ahn;
    int aho;
    public static final LocationAvailabilityCreator CREATOR = new LocationAvailabilityCreator();

    LocationAvailability(int n, int n2, int n3, int n4, long l) {
        this.mVersionCode = n;
        this.aho = n2;
        this.ahl = n3;
        this.ahm = n4;
        this.ahn = l;
    }

    public boolean isLocationAvailable() {
        return this.aho < 1000;
    }

    public void writeToParcel(Parcel parcel, int n) {
        LocationAvailabilityCreator.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.aho, this.ahl, this.ahm, this.ahn});
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocationAvailability)) {
            return false;
        }
        LocationAvailability locationAvailability = (LocationAvailability)((Object)object);
        return this.aho == locationAvailability.aho && this.ahl == locationAvailability.ahl && this.ahm == locationAvailability.ahm && this.ahn == locationAvailability.ahn;
    }

    public String toString() {
        boolean bl = this.isLocationAvailable();
        return new StringBuilder(48).append("LocationAvailability[isLocationAvailable: ").append(bl).append("]").toString();
    }

    public static boolean hasLocationAvailability(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_AVAILABILITY");
    }

    public static LocationAvailability extractLocationAvailability(Intent intent) {
        if (!LocationAvailability.hasLocationAvailability(intent)) {
            return null;
        }
        return (LocationAvailability)intent.getExtras().getParcelable("com.google.android.gms.location.EXTRA_LOCATION_AVAILABILITY");
    }
}

