/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.ParcelableGeofence;
import com.google.android.gms.location.zzd;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
extends AbstractSafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzd();
    private final int mVersionCode;
    private final List<ParcelableGeofence> ahe;
    private final int ahf;

    GeofencingRequest(int n, List<ParcelableGeofence> list, int n2) {
        this.mVersionCode = n;
        this.ahe = list;
        this.ahf = n2;
    }

    private GeofencingRequest(List<ParcelableGeofence> list, int n) {
        this(1, list, n);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public List<ParcelableGeofence> zzbpf() {
        return this.ahe;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.ahe);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.ahf;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public static final class Builder {
        private final List<ParcelableGeofence> ahe = new ArrayList<ParcelableGeofence>();
        private int ahf = 5;

        public Builder addGeofence(Geofence geofence) {
            zzac.zzb((Object)geofence, (Object)"geofence can't be null.");
            zzac.zzb((boolean)(geofence instanceof ParcelableGeofence), (Object)"Geofence must be created using Geofence.Builder.");
            this.ahe.add((ParcelableGeofence)geofence);
            return this;
        }

        public Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public Builder setInitialTrigger(int n) {
            this.ahf = Builder.zzua(n);
            return this;
        }

        public static int zzua(int n) {
            return n & 7;
        }

        public GeofencingRequest build() {
            zzac.zzb((!this.ahe.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.ahe, this.ahf);
        }
    }
}

