/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.ParcelableGeofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int zzcdb;
    private final int ahb;
    private final List<Geofence> ahc;
    private final Location ahd;

    private GeofencingEvent(int n, int n2, List<Geofence> list, Location location) {
        this.zzcdb = n;
        this.ahb = n2;
        this.ahc = list;
        this.ahd = location;
    }

    public static GeofencingEvent fromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        int n = intent.getIntExtra("gms_error_code", -1);
        int n2 = GeofencingEvent.zzaa(intent);
        List<Geofence> list = GeofencingEvent.zzab(intent);
        Location location = (Location)intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        return new GeofencingEvent(n, n2, list, location);
    }

    private static int zzaa(Intent intent) {
        int n = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n == -1) {
            return -1;
        }
        if (n == 1 || n == 2 || n == 4) {
            return n;
        }
        return -1;
    }

    private static List<Geofence> zzab(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(ParcelableGeofence.zzv(byArray));
        }
        return arrayList2;
    }

    public boolean hasError() {
        return this.zzcdb != -1;
    }

    public int getErrorCode() {
        return this.zzcdb;
    }

    public int getGeofenceTransition() {
        return this.ahb;
    }

    public List<Geofence> getTriggeringGeofences() {
        return this.ahc;
    }

    public Location getTriggeringLocation() {
        return this.ahd;
    }
}

