/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.location.internal.ParcelableGeofence;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzcaj = null;
        private int agT = 0;
        private long agU = Long.MIN_VALUE;
        private short agV = (short)-1;
        private double agW;
        private double agX;
        private float agY;
        private int agZ = 0;
        private int aha = -1;

        public Builder setRequestId(String string) {
            this.zzcaj = string;
            return this;
        }

        public Builder setTransitionTypes(int n) {
            this.agT = n;
            return this;
        }

        public Builder setExpirationDuration(long l) {
            this.agU = l < 0L ? -1L : SystemClock.elapsedRealtime() + l;
            return this;
        }

        public Builder setCircularRegion(double d, double d2, float f) {
            this.agV = 1;
            this.agW = d;
            this.agX = d2;
            this.agY = f;
            return this;
        }

        public Builder setNotificationResponsiveness(int n) {
            this.agZ = n;
            return this;
        }

        public Builder setLoiteringDelay(int n) {
            this.aha = n;
            return this;
        }

        public Geofence build() {
            if (this.zzcaj == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.agT == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.agT & 4) != 0 && this.aha < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.agU == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.agV == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.agZ < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new ParcelableGeofence(this.zzcaj, this.agT, 1, this.agW, this.agX, this.agY, this.agU, this.agZ, this.aha);
        }
    }
}

