/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.internal.ClientIdentity;
import com.google.android.gms.location.zzc;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class ActivityTransitionRequest
extends AbstractSafeParcelable {
    public static final zzc CREATOR = new zzc();
    public static final Comparator<ActivityTransition> agL = new Comparator<ActivityTransition>(){

        public int zza(ActivityTransition activityTransition, ActivityTransition activityTransition2) {
            int n;
            int n2;
            int n3 = activityTransition.zzbeb();
            if (n3 != (n2 = activityTransition2.zzbeb())) {
                return n3 < n2 ? -1 : 1;
            }
            int n4 = activityTransition.zzbpc();
            return n4 == (n = activityTransition2.zzbpc()) ? 0 : (n4 < n ? -1 : 1);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((ActivityTransition)((Object)object), (ActivityTransition)((Object)object2));
        }
    };
    private final int mVersionCode;
    private final List<ActivityTransition> agM;
    @Nullable
    private final String mTag;
    private final List<ClientIdentity> agN;

    ActivityTransitionRequest(int n, List<ActivityTransition> list, @Nullable String string, @Nullable List<ClientIdentity> list2) {
        zzac.zzb(list, (Object)"transitions can't be null");
        zzac.zzb((list.size() > 0 ? 1 : 0) != 0, (Object)"transitions can't be empty.");
        ActivityTransitionRequest.zzab(list);
        this.mVersionCode = n;
        this.agM = Collections.unmodifiableList(list);
        this.mTag = string;
        this.agN = list2 == null ? Collections.emptyList() : Collections.unmodifiableList(list2);
    }

    private static void zzab(List<ActivityTransition> list) {
        TreeSet<ActivityTransition> treeSet = new TreeSet<ActivityTransition>(agL);
        for (ActivityTransition activityTransition : list) {
            zzac.zzb((boolean)treeSet.add(activityTransition), (Object)String.format("Found duplicated transition: %s.", new Object[]{activityTransition}));
        }
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public List<ActivityTransition> zzbpd() {
        return this.agM;
    }

    @Nullable
    public String getTag() {
        return this.mTag;
    }

    public List<ClientIdentity> zzbpe() {
        return this.agN;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ActivityTransitionRequest activityTransitionRequest = (ActivityTransitionRequest)((Object)object);
        return zzab.equal(this.agM, activityTransitionRequest.agM) && zzab.equal((Object)this.mTag, (Object)activityTransitionRequest.mTag) && zzab.equal(this.agN, activityTransitionRequest.agN);
    }

    public String toString() {
        String string = String.valueOf(this.agM);
        String string2 = this.mTag;
        String string3 = String.valueOf(this.agN);
        return new StringBuilder(61 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ActivityTransitionRequest [mTransitions=").append(string).append(", mTag='").append(string2).append("'").append(", mClients=").append(string3).append("]").toString();
    }

    public int hashCode() {
        int n = this.agM.hashCode();
        n = 31 * n + (this.mTag != null ? this.mTag.hashCode() : 0);
        n = 31 * n + (this.agN != null ? this.agN.hashCode() : 0);
        return n;
    }
}

