/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.location.ActivityRecognitionResultCreator;
import com.google.android.gms.location.DetectedActivity;
import java.util.Collections;
import java.util.List;

public class ActivityRecognitionResult
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final ActivityRecognitionResultCreator CREATOR = new ActivityRecognitionResultCreator();
    private final int mVersionCode;
    List<DetectedActivity> agG;
    long agH;
    long agI;
    int agJ;
    Bundle extras;

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2) {
        this(list, l, l2, 0, null);
    }

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2, int n, Bundle bundle) {
        zzac.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 detected activity");
        zzac.zzb((l > 0L && l2 > 0L ? 1 : 0) != 0, (Object)"Must set times");
        this.mVersionCode = 2;
        this.agG = list;
        this.agH = l;
        this.agI = l2;
        this.agJ = n;
        this.extras = bundle;
    }

    public ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2) {
        this(detectedActivity, l, l2, 0, null);
    }

    public ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2, int n, Bundle bundle) {
        this(Collections.singletonList(detectedActivity), l, l2, n, bundle);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        if (ActivityRecognitionResult.zzw(intent)) {
            return true;
        }
        List<ActivityRecognitionResult> list = ActivityRecognitionResult.zzz(intent);
        return list != null && !list.isEmpty();
    }

    private static boolean zzw(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
    }

    public static ActivityRecognitionResult extractResult(Intent intent) {
        ActivityRecognitionResult activityRecognitionResult = ActivityRecognitionResult.zzx(intent);
        if (activityRecognitionResult != null) {
            return activityRecognitionResult;
        }
        List<ActivityRecognitionResult> list = ActivityRecognitionResult.zzz(intent);
        return list == null || list.isEmpty() ? null : list.get(list.size() - 1);
    }

    private static ActivityRecognitionResult zzx(Intent intent) {
        if (!ActivityRecognitionResult.hasResult(intent)) {
            return null;
        }
        Object object = intent.getExtras().get("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
        if (object instanceof byte[]) {
            return (ActivityRecognitionResult)zzc.zza((byte[])((byte[])object), (Parcelable.Creator)CREATOR);
        }
        if (object instanceof ActivityRecognitionResult) {
            return (ActivityRecognitionResult)((Object)object);
        }
        return null;
    }

    public static boolean zzy(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST");
    }

    @Nullable
    public static List<ActivityRecognitionResult> zzz(Intent intent) {
        if (!ActivityRecognitionResult.zzy(intent)) {
            return null;
        }
        return zzc.zzb((Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST", (Parcelable.Creator)CREATOR);
    }

    public DetectedActivity getMostProbableActivity() {
        return this.agG.get(0);
    }

    public int getActivityConfidence(int n) {
        for (DetectedActivity detectedActivity : this.agG) {
            if (detectedActivity.getType() != n) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.agG;
    }

    public long getTime() {
        return this.agH;
    }

    public long getElapsedRealtimeMillis() {
        return this.agI;
    }

    public String toString() {
        String string = String.valueOf(this.agG);
        long l = this.agH;
        long l2 = this.agI;
        return new StringBuilder(124 + String.valueOf(string).length()).append("ActivityRecognitionResult [probableActivities=").append(string).append(", timeMillis=").append(l).append(", elapsedRealtimeMillis=").append(l2).append("]").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)((Object)object);
        return this.agH == activityRecognitionResult.agH && this.agI == activityRecognitionResult.agI && this.agJ == activityRecognitionResult.agJ && zzab.equal(this.agG, activityRecognitionResult.agG) && ActivityRecognitionResult.zzc(this.extras, activityRecognitionResult.extras);
    }

    private static boolean zzc(Bundle bundle, Bundle bundle2) {
        if (bundle == null && bundle2 == null) {
            return true;
        }
        if (bundle == null && bundle2 != null || bundle != null && bundle2 == null) {
            return false;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string : bundle.keySet()) {
            if (!bundle2.containsKey(string)) {
                return false;
            }
            if (!(bundle.get(string) == null ? bundle2.get(string) != null : (bundle.get(string) instanceof Bundle ? !ActivityRecognitionResult.zzc(bundle.getBundle(string), bundle2.getBundle(string)) : !bundle.get(string).equals(bundle2.get(string))))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.agH, this.agI, this.agJ, this.agG, this.extras});
    }

    public ActivityRecognitionResult(int n, List<DetectedActivity> list, long l, long l2, int n2, Bundle bundle) {
        this.mVersionCode = n;
        this.agG = list;
        this.agH = l;
        this.agI = l2;
        this.agJ = n2;
        this.extras = bundle;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        ActivityRecognitionResultCreator.zza(this, parcel, n);
    }
}

