/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentId;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.RegisterSectionInfo;
import com.google.android.gms.appdatasearch.zzj;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzvc;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import java.util.zip.CRC32;

public class UsageInfo
extends AbstractSafeParcelable {
    public static final zzj CREATOR = new zzj();
    final int mVersionCode;
    final DocumentId eL;
    final long eM;
    int eN;
    public final String zzbab;
    final DocumentContents eO;
    final boolean eP;
    int eQ;
    int eR;

    private UsageInfo(DocumentId documentId, long l, int n, String string, DocumentContents documentContents, boolean bl, int n2, int n3) {
        this(1, documentId, l, n, string, documentContents, bl, n2, n3);
    }

    public UsageInfo(String string, Intent intent, String string2, Uri uri, String string3, List<AppIndexApi.AppIndexingLink> list, int n) {
        this(1, UsageInfo.zza(string, intent), System.currentTimeMillis(), 0, null, UsageInfo.zza(intent, string2, uri, string3, list).zzage(), false, -1, n);
    }

    UsageInfo(int n, DocumentId documentId, long l, int n2, String string, DocumentContents documentContents, boolean bl, int n3, int n4) {
        this.mVersionCode = n;
        this.eL = documentId;
        this.eM = l;
        this.eN = n2;
        this.zzbab = string;
        this.eO = documentContents;
        this.eP = bl;
        this.eQ = n3;
        this.eR = n4;
    }

    public static DocumentId zza(String string, Intent intent) {
        return UsageInfo.zzt(string, UsageInfo.zzg(intent));
    }

    private static DocumentId zzt(String string, String string2) {
        return new DocumentId(string, "", string2);
    }

    private static DocumentSection zzfq(String string) {
        return new DocumentSection(string, new RegisterSectionInfo.zza("title").zzcl(1).zzaz(true).zzfp("name").zzagh(), "text1");
    }

    private static DocumentSection zzk(Uri uri) {
        return new DocumentSection(uri.toString(), new RegisterSectionInfo.zza("web_url").zzcl(4).zzay(true).zzfp("url").zzagh());
    }

    private static DocumentSection zzu(String string, String string2) {
        return new DocumentSection(string2, new RegisterSectionInfo.zza(string).zzay(true).zzagh(), string);
    }

    private static String zzg(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static DocumentSection zzv(List<AppIndexApi.AppIndexingLink> list) {
        zzvc.zza zza2 = new zzvc.zza();
        zzvc.zza.zza[] zzaArray = new zzvc.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zzvc.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].aft = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].afu = appIndexingLink.webUrl.toString();
        }
        zza2.afr = zzaArray;
        return new DocumentSection(zzark.zzf((zzark)zza2), new RegisterSectionInfo.zza("outlinks").zzay(true).zzfp(".private:outLinks").zzfo("blob").zzagh());
    }

    public static DocumentContents.zza zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        DocumentContents.zza zza2 = new DocumentContents.zza();
        zza2.zza(UsageInfo.zzfq(string));
        if (uri != null) {
            zza2.zza(UsageInfo.zzk(uri));
        }
        if (list != null) {
            zza2.zza(UsageInfo.zzv(list));
        }
        if ((string5 = intent.getAction()) != null) {
            zza2.zza(UsageInfo.zzu("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zza2.zza(UsageInfo.zzu("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(UsageInfo.zzu("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(UsageInfo.zzu("intent_extra_data", string3));
        }
        return zza2.zzfm(string2).zzax(true);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzj.zza(this, parcel, n);
    }

    public String toString() {
        return String.format(Locale.US, "UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", new Object[]{this.eL, this.eM, this.eN, this.eR});
    }

    public static final class zza {
        private DocumentId eL;
        private long eM = -1L;
        private int eN = -1;
        private DocumentContents eO;
        private boolean eP = false;
        private int eQ = -1;
        private int eR = 0;

        public zza zza(DocumentId documentId) {
            this.eL = documentId;
            return this;
        }

        public zza zzaa(long l) {
            this.eM = l;
            return this;
        }

        public zza zzcn(int n) {
            this.eN = n;
            return this;
        }

        public zza zza(DocumentContents documentContents) {
            this.eO = documentContents;
            return this;
        }

        public zza zzba(boolean bl) {
            this.eP = bl;
            return this;
        }

        public zza zzco(int n) {
            this.eR = n;
            return this;
        }

        public UsageInfo zzagi() {
            return new UsageInfo(this.eL, this.eM, this.eN, null, this.eO, this.eP, this.eQ, this.eR);
        }
    }
}

