/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.os.Bundle;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.search.SearchAdRequest;

public final class DynamicHeightSearchAdRequest {
    private final SearchAdRequest zzcxp;

    private DynamicHeightSearchAdRequest(Builder builder) {
        this.zzcxp = builder.zzcxq.build();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzcxp.getNetworkExtras(clazz);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzcxp.getNetworkExtrasBundle(clazz);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzcxp.getCustomEventExtrasBundle(clazz);
    }

    public String getQuery() {
        return this.zzcxp.getQuery();
    }

    public boolean isTestDevice(Context context) {
        return this.zzcxp.isTestDevice(context);
    }

    zzad zzdg() {
        return this.zzcxp.zzdg();
    }

    public static final class Builder {
        private final SearchAdRequest.Builder zzcxq = new SearchAdRequest.Builder();
        private final Bundle zzcxr = new Bundle();

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzcxq.addNetworkExtras(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzcxq.addNetworkExtrasBundle(clazz, bundle);
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzcxq.addCustomEventExtrasBundle(clazz, bundle);
            return this;
        }

        public Builder setPage(int n) {
            this.zzcxr.putString("csa_adPage", Integer.toString(n));
            return this;
        }

        public Builder setNumber(int n) {
            this.zzcxr.putString("csa_number", Integer.toString(n));
            return this;
        }

        public Builder setAdTest(boolean bl) {
            this.zzcxr.putString("csa_adtest", bl ? "on" : "off");
            return this;
        }

        public Builder setChannel(String string) {
            this.zzcxr.putString("csa_channel", string);
            return this;
        }

        public Builder setHostLanguage(String string) {
            this.zzcxr.putString("csa_hl", string);
            return this;
        }

        public Builder setLocationColor(String string) {
            this.zzcxr.putString("csa_colorLocation", string);
            return this;
        }

        public Builder setLocationFontSize(int n) {
            this.zzcxr.putString("csa_fontSizeLocation", Integer.toString(n));
            return this;
        }

        public Builder setIsClickToCallEnabled(boolean bl) {
            this.zzcxr.putString("csa_clickToCall", Boolean.toString(bl));
            return this;
        }

        public Builder setIsLocationEnabled(boolean bl) {
            this.zzcxr.putString("csa_location", Boolean.toString(bl));
            return this;
        }

        public Builder setIsPlusOnesEnabled(boolean bl) {
            this.zzcxr.putString("csa_plusOnes", Boolean.toString(bl));
            return this;
        }

        public Builder setIsSellerRatingsEnabled(boolean bl) {
            this.zzcxr.putString("csa_sellerRatings", Boolean.toString(bl));
            return this;
        }

        public Builder setIsSiteLinksEnabled(boolean bl) {
            this.zzcxr.putString("csa_siteLinks", Boolean.toString(bl));
            return this;
        }

        public Builder setCssWidth(int n) {
            this.zzcxr.putString("csa_width", Integer.toString(n));
            return this;
        }

        @Deprecated
        public Builder setFontFamily(int n) {
            return this.setFontFamily(Integer.toString(n));
        }

        public Builder setFontFamily(String string) {
            this.zzcxr.putString("csa_fontFamily", string);
            return this;
        }

        public Builder setFontFamilyAttribution(String string) {
            this.zzcxr.putString("csa_fontFamilyAttribution", string);
            return this;
        }

        public Builder setFontSizeAnnotation(int n) {
            this.zzcxr.putString("csa_fontSizeAnnotation", Integer.toString(n));
            return this;
        }

        public Builder setFontSizeAttribution(int n) {
            this.zzcxr.putString("csa_fontSizeAttribution", Integer.toString(n));
            return this;
        }

        public Builder setFontSizeDescription(int n) {
            this.zzcxr.putString("csa_fontSizeDescription", Integer.toString(n));
            return this;
        }

        public Builder setFontSizeDomainLink(int n) {
            this.zzcxr.putString("csa_fontSizeDomainLink", Integer.toString(n));
            return this;
        }

        public Builder setFontSizeTitle(int n) {
            this.zzcxr.putString("csa_fontSizeTitle", Integer.toString(n));
            return this;
        }

        public Builder setColorAdBorder(String string) {
            this.zzcxr.putString("csa_colorAdBorder", string);
            return this;
        }

        public Builder setColorAdSeparator(String string) {
            this.zzcxr.putString("csa_colorAdSeparator", string);
            return this;
        }

        public Builder setColorAnnotation(String string) {
            this.zzcxr.putString("csa_colorAnnotation", string);
            return this;
        }

        public Builder setColorAttribution(String string) {
            this.zzcxr.putString("csa_colorAttribution", string);
            return this;
        }

        public Builder setColorBackground(String string) {
            this.zzcxr.putString("csa_colorBackground", string);
            return this;
        }

        public Builder setColorBorder(String string) {
            this.zzcxr.putString("csa_colorBorder", string);
            return this;
        }

        public Builder setColorDomainLink(String string) {
            this.zzcxr.putString("csa_colorDomainLink", string);
            return this;
        }

        public Builder setColorText(String string) {
            this.zzcxr.putString("csa_colorText", string);
            return this;
        }

        public Builder setColorTitleLink(String string) {
            this.zzcxr.putString("csa_colorTitleLink", string);
            return this;
        }

        public Builder setAdBorderSelectors(String string) {
            this.zzcxr.putString("csa_adBorderSelectors", string);
            return this;
        }

        public Builder setAdjustableLineHeight(int n) {
            this.zzcxr.putString("csa_adjustableLineHeight", Integer.toString(n));
            return this;
        }

        public Builder setAttributionSpacingBelow(int n) {
            this.zzcxr.putString("csa_attributionSpacingBelow", Integer.toString(n));
            return this;
        }

        public Builder setBorderSelections(String string) {
            this.zzcxr.putString("csa_borderSelections", string);
            return this;
        }

        public Builder setIsTitleUnderlined(boolean bl) {
            this.zzcxr.putString("csa_noTitleUnderline", Boolean.toString(!bl));
            return this;
        }

        public Builder setIsTitleBold(boolean bl) {
            this.zzcxr.putString("csa_titleBold", Boolean.toString(bl));
            return this;
        }

        public Builder setVerticalSpacing(int n) {
            this.zzcxr.putString("csa_verticalSpacing", Integer.toString(n));
            return this;
        }

        public Builder setDetailedAttribution(boolean bl) {
            this.zzcxr.putString("csa_detailedAttribution", Boolean.toString(bl));
            return this;
        }

        public Builder setLongerHeadlines(boolean bl) {
            this.zzcxr.putString("csa_longerHeadlines", Boolean.toString(bl));
            return this;
        }

        public Builder setAdvancedOptionValue(String string, String string2) {
            this.zzcxr.putString(string, string2);
            return this;
        }

        public DynamicHeightSearchAdRequest build() {
            this.zzcxq.addNetworkExtrasBundle(AdMobAdapter.class, this.zzcxr);
            return new DynamicHeightSearchAdRequest(this);
        }

        public Builder setQuery(String string) {
            this.zzcxq.setQuery(string);
            return this;
        }
    }
}

