/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzo;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zziy;
import java.util.concurrent.atomic.AtomicBoolean;

@zziy
public class zzae {
    private final zzgp zzays = new zzgp();
    private final zzh zzajr;
    private final AtomicBoolean zzayt;
    private final VideoController zzayu = new VideoController();
    final zzo zzayv = new zzo(){

        @Override
        public void onAdLoaded() {
            zzae.this.zzayu.zza(zzae.this.zzdj());
            super.onAdLoaded();
        }

        @Override
        public void onAdFailedToLoad(int n) {
            zzae.this.zzayu.zza(zzae.this.zzdj());
            super.onAdFailedToLoad(n);
        }
    };
    private zza zzawb;
    private AdListener zzawc;
    private AdSize[] zzaxp;
    private AppEventListener zzaxo;
    private Correlator zzayw;
    private zzu zzayx;
    private InAppPurchaseListener zzayy;
    private OnCustomRenderedAdLoadedListener zzayz;
    private PlayStorePurchaseListener zzaza;
    private VideoOptions zzakr;
    private String zzang;
    private String zzazb;
    private ViewGroup zzazc;
    private boolean zzazd;
    private boolean zzami;

    public zzae(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzh.zzjb(), false);
    }

    public zzae(ViewGroup viewGroup, boolean bl) {
        this(viewGroup, null, false, zzh.zzjb(), bl);
    }

    public zzae(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzh.zzjb(), false);
    }

    public zzae(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, boolean bl2) {
        this(viewGroup, attributeSet, bl, zzh.zzjb(), bl2);
    }

    zzae(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzh zzh2, zzu zzu2, boolean bl2) {
        this.zzazc = viewGroup;
        this.zzajr = zzh2;
        this.zzayx = zzu2;
        this.zzayt = new AtomicBoolean(false);
        this.zzazd = bl2;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzk zzk2 = new zzk(context, attributeSet);
                this.zzaxp = zzk2.zzm(bl);
                this.zzang = zzk2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzm.zzjr().zza(viewGroup, new AdSizeParcel(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzm.zzjr().zza(viewGroup, zzae.zza(context, this.zzaxp[0], this.zzazd), "Ads by Google");
            }
        }
    }

    zzae(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzh zzh2, boolean bl2) {
        this(viewGroup, attributeSet, bl, zzh2, null, bl2);
    }

    public void destroy() {
        try {
            if (this.zzayx != null) {
                this.zzayx.destroy();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.zzawc;
    }

    public AdSize getAdSize() {
        try {
            AdSizeParcel adSizeParcel;
            if (this.zzayx != null && (adSizeParcel = this.zzayx.zzdt()) != null) {
                return adSizeParcel.zzjd();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the current AdSize.", remoteException);
        }
        return this.zzaxp != null ? this.zzaxp[0] : null;
    }

    public AdSize[] getAdSizes() {
        return this.zzaxp;
    }

    public String getAdUnitId() {
        return this.zzang;
    }

    public AppEventListener getAppEventListener() {
        return this.zzaxo;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzayy;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzayz;
    }

    public void zza(zzad zzad2) {
        try {
            if (this.zzayx == null) {
                this.zzkg();
            }
            if (this.zzayx.zzb(this.zzajr.zza(this.zzazc.getContext(), zzad2))) {
                this.zzays.zzh(zzad2.zzkb());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.zzayx != null) {
                this.zzayx.pause();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call pause.", remoteException);
        }
    }

    public void recordManualImpression() {
        if (this.zzayt.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzayx != null) {
                this.zzayx.zzdv();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to record impression.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.zzayx != null) {
                this.zzayx.resume();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        this.zzawc = adListener;
        this.zzayv.zza(adListener);
    }

    public void zza(zza zza2) {
        try {
            this.zzawb = zza2;
            if (this.zzayx != null) {
                this.zzayx.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzaxp != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public void zza(AdSize ... adSizeArray) {
        this.zzaxp = adSizeArray;
        try {
            if (this.zzayx != null) {
                this.zzayx.zza(zzae.zza(this.zzazc.getContext(), this.zzaxp, this.zzazd));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the ad size.", remoteException);
        }
        this.zzazc.requestLayout();
    }

    public void setAdUnitId(String string) {
        if (this.zzang != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzang = string;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzaxo = appEventListener;
            if (this.zzayx != null) {
                this.zzayx.zza(appEventListener != null ? new zzj(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzaza != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzayy = inAppPurchaseListener;
            if (this.zzayx != null) {
                this.zzayx.zza(inAppPurchaseListener != null ? new zzic(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzayz = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzayx != null) {
                this.zzayx.zza(onCustomRenderedAdLoadedListener != null ? new zzdv(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String string) {
        if (this.zzayy != null) {
            throw new IllegalStateException("InAppPurchaseListener has already been set.");
        }
        try {
            this.zzaza = playStorePurchaseListener;
            this.zzazb = string;
            if (this.zzayx != null) {
                this.zzayx.zza(playStorePurchaseListener != null ? new zzig(playStorePurchaseListener) : null, string);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setManualImpressionsEnabled(boolean bl) {
        this.zzami = bl;
        try {
            if (this.zzayx != null) {
                this.zzayx.setManualImpressionsEnabled(this.zzami);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set manual impressions.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzayw = correlator;
        try {
            if (this.zzayx != null) {
                this.zzayx.zza(this.zzayw == null ? null : this.zzayw.zzdh());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set correlator.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzayx != null) {
                return this.zzayx.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public boolean isLoading() {
        try {
            if (this.zzayx != null) {
                return this.zzayx.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public VideoController getVideoController() {
        return this.zzayu;
    }

    public zzab zzdj() {
        if (this.zzayx == null) {
            return null;
        }
        try {
            return this.zzayx.zzdw();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public void setVideoOptions(VideoOptions videoOptions) {
        this.zzakr = videoOptions;
        try {
            if (this.zzayx != null) {
                this.zzayx.zza(videoOptions == null ? null : new VideoOptionsParcel(videoOptions));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set video options.", remoteException);
        }
    }

    public VideoOptions getVideoOptions() {
        return this.zzakr;
    }

    private void zzkf() {
        try {
            zzd zzd2 = this.zzayx.zzds();
            if (zzd2 == null) {
                return;
            }
            this.zzazc.addView((View)zze.zzae((zzd)zzd2));
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get an ad frame.", remoteException);
        }
    }

    void zzkg() throws RemoteException {
        if ((this.zzaxp == null || this.zzang == null) && this.zzayx == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
        }
        this.zzayx = this.zzkh();
        this.zzayx.zza(new zzc(this.zzayv));
        if (this.zzawb != null) {
            this.zzayx.zza(new zzb(this.zzawb));
        }
        if (this.zzaxo != null) {
            this.zzayx.zza(new zzj(this.zzaxo));
        }
        if (this.zzayy != null) {
            this.zzayx.zza(new zzic(this.zzayy));
        }
        if (this.zzaza != null) {
            this.zzayx.zza(new zzig(this.zzaza), this.zzazb);
        }
        if (this.zzayz != null) {
            this.zzayx.zza(new zzdv(this.zzayz));
        }
        if (this.zzayw != null) {
            this.zzayx.zza(this.zzayw.zzdh());
        }
        if (this.zzakr != null) {
            this.zzayx.zza(new VideoOptionsParcel(this.zzakr));
        }
        this.zzayx.setManualImpressionsEnabled(this.zzami);
        this.zzkf();
    }

    protected zzu zzkh() throws RemoteException {
        Context context = this.zzazc.getContext();
        AdSizeParcel adSizeParcel = zzae.zza(context, this.zzaxp, this.zzazd);
        if (this.zzb(adSizeParcel)) {
            return zzm.zzjs().zza(context, adSizeParcel, this.zzang);
        }
        return zzm.zzjs().zza(context, adSizeParcel, this.zzang, this.zzays);
    }

    private static AdSizeParcel zza(Context context, AdSize[] adSizeArray, boolean bl) {
        AdSizeParcel adSizeParcel = new AdSizeParcel(context, adSizeArray);
        adSizeParcel.zzl(bl);
        return adSizeParcel;
    }

    private static AdSizeParcel zza(Context context, AdSize adSize, boolean bl) {
        AdSizeParcel adSizeParcel = new AdSizeParcel(context, adSize);
        adSizeParcel.zzl(bl);
        return adSizeParcel;
    }

    public boolean zzb(AdSizeParcel adSizeParcel) {
        return "search_v2".equals(adSizeParcel.zzaxi);
    }
}

