/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.zzac;
import java.util.Date;
import java.util.Set;

public final class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    public static final String DEVICE_ID_EMULATOR = zzad.DEVICE_ID_EMULATOR;
    private final zzad zzaju;

    private AdRequest(Builder builder) {
        this.zzaju = new zzad(builder.zzajv);
    }

    public Date getBirthday() {
        return this.zzaju.getBirthday();
    }

    public String getContentUrl() {
        return this.zzaju.getContentUrl();
    }

    public int getGender() {
        return this.zzaju.getGender();
    }

    public Set<String> getKeywords() {
        return this.zzaju.getKeywords();
    }

    public Location getLocation() {
        return this.zzaju.getLocation();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzaju.getNetworkExtras(clazz);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzaju.getNetworkExtrasBundle(clazz);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzaju.getCustomEventExtrasBundle(clazz);
    }

    public boolean isTestDevice(Context context) {
        return this.zzaju.isTestDevice(context);
    }

    public zzad zzdg() {
        return this.zzaju;
    }

    public static final class Builder {
        private final zzad.zza zzajv = new zzad.zza();

        public Builder() {
            this.zzajv.zzaj(DEVICE_ID_EMULATOR);
        }

        public Builder addKeyword(String string) {
            this.zzajv.zzai(string);
            return this;
        }

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzajv.zza(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzajv.zza(clazz, bundle);
            if (clazz.equals(AdMobAdapter.class) && bundle.getBoolean("_emulatorLiveAds")) {
                this.zzajv.zzak(DEVICE_ID_EMULATOR);
            }
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzajv.zzb(clazz, bundle);
            return this;
        }

        public Builder addTestDevice(String string) {
            this.zzajv.zzaj(string);
            return this;
        }

        public AdRequest build() {
            return new AdRequest(this);
        }

        public Builder setBirthday(Date date) {
            this.zzajv.zza(date);
            return this;
        }

        public Builder setContentUrl(String string) {
            zzac.zzb((Object)string, (Object)"Content URL must be non-null.");
            zzac.zzh((String)string, (Object)"Content URL must be non-empty.");
            zzac.zzb((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzajv.zzal(string);
            return this;
        }

        public Builder setGender(int n) {
            this.zzajv.zzv(n);
            return this;
        }

        public Builder setLocation(Location location) {
            this.zzajv.zzb(location);
            return this;
        }

        public Builder setRequestAgent(String string) {
            this.zzajv.zzan(string);
            return this;
        }

        public Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzajv.zzo(bl);
            return this;
        }

        public Builder setIsDesignedForFamilies(boolean bl) {
            this.zzajv.zzp(bl);
            return this;
        }
    }
}

