/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.query.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.internal.ComparisonFilter;
import com.google.android.gms.drive.query.internal.FieldOnlyFilter;
import com.google.android.gms.drive.query.internal.FullTextSearchFilter;
import com.google.android.gms.drive.query.internal.HasFilter;
import com.google.android.gms.drive.query.internal.InFilter;
import com.google.android.gms.drive.query.internal.LogicalFilter;
import com.google.android.gms.drive.query.internal.MatchAllFilter;
import com.google.android.gms.drive.query.internal.NotFilter;
import com.google.android.gms.drive.query.internal.OwnedByMeFilter;
import com.google.android.gms.drive.query.internal.zzd;

public class FilterHolder
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<FilterHolder> CREATOR = new zzd();
    final int mVersionCode;
    final ComparisonFilter<?> MV;
    final FieldOnlyFilter MW;
    final LogicalFilter MX;
    final NotFilter MY;
    final InFilter<?> MZ;
    final MatchAllFilter Na;
    final HasFilter Nb;
    final FullTextSearchFilter Nc;
    final OwnedByMeFilter Nd;
    private final Filter HR;

    FilterHolder(int n, ComparisonFilter<?> comparisonFilter, FieldOnlyFilter fieldOnlyFilter, LogicalFilter logicalFilter, NotFilter notFilter, InFilter<?> inFilter, MatchAllFilter matchAllFilter, HasFilter<?> hasFilter, FullTextSearchFilter fullTextSearchFilter, OwnedByMeFilter ownedByMeFilter) {
        this.mVersionCode = n;
        this.MV = comparisonFilter;
        this.MW = fieldOnlyFilter;
        this.MX = logicalFilter;
        this.MY = notFilter;
        this.MZ = inFilter;
        this.Na = matchAllFilter;
        this.Nb = hasFilter;
        this.Nc = fullTextSearchFilter;
        this.Nd = ownedByMeFilter;
        if (this.MV != null) {
            this.HR = this.MV;
        } else if (this.MW != null) {
            this.HR = this.MW;
        } else if (this.MX != null) {
            this.HR = this.MX;
        } else if (this.MY != null) {
            this.HR = this.MY;
        } else if (this.MZ != null) {
            this.HR = this.MZ;
        } else if (this.Na != null) {
            this.HR = this.Na;
        } else if (this.Nb != null) {
            this.HR = this.Nb;
        } else if (this.Nc != null) {
            this.HR = this.Nc;
        } else if (this.Nd != null) {
            this.HR = this.Nd;
        } else {
            throw new IllegalArgumentException("At least one filter must be set.");
        }
    }

    public FilterHolder(Filter filter) {
        zzac.zzb((Object)filter, (Object)"Null filter.");
        this.mVersionCode = 2;
        this.MV = filter instanceof ComparisonFilter ? (ComparisonFilter)filter : null;
        this.MW = filter instanceof FieldOnlyFilter ? (FieldOnlyFilter)filter : null;
        this.MX = filter instanceof LogicalFilter ? (LogicalFilter)filter : null;
        this.MY = filter instanceof NotFilter ? (NotFilter)filter : null;
        this.MZ = filter instanceof InFilter ? (InFilter)filter : null;
        this.Na = filter instanceof MatchAllFilter ? (MatchAllFilter)filter : null;
        this.Nb = filter instanceof HasFilter ? (HasFilter)filter : null;
        this.Nc = filter instanceof FullTextSearchFilter ? (FullTextSearchFilter)filter : null;
        OwnedByMeFilter ownedByMeFilter = this.Nd = filter instanceof OwnedByMeFilter ? (OwnedByMeFilter)filter : null;
        if (this.MV == null && this.MW == null && this.MX == null && this.MY == null && this.MZ == null && this.Na == null && this.Nb == null && this.Nc == null && this.Nd == null) {
            throw new IllegalArgumentException("Invalid filter type.");
        }
        this.HR = filter;
    }

    public Filter getFilter() {
        return this.HR;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public String toString() {
        return String.format("FilterHolder[%s]", this.HR);
    }
}

