/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CreateFileRequest;
import com.google.android.gms.drive.internal.CreateFolderRequest;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.zzab;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzv;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.metadata.internal.zzi;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.drive.zzh;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzsp;

public class zzy
extends zzab
implements DriveFolder {
    public zzy(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient googleApiClient) {
        return this.queryChildren(googleApiClient, null);
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient googleApiClient, Query query) {
        return new zzs().query(googleApiClient, this.zza(query));
    }

    private Query zza(Query query) {
        Query.Builder builder = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, this.getDriveId()));
        if (query != null) {
            if (query.getFilter() != null) {
                builder.addFilter(query.getFilter());
            }
            builder.setPageToken(query.getPageToken());
            builder.setSortOrder(query.getSortOrder());
        }
        return builder.build();
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents) {
        this.zzb(metadataChangeSet);
        return this.zza(googleApiClient, metadataChangeSet, driveContents, null);
    }

    @Override
    public PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        this.zzb(metadataChangeSet);
        return this.zza(googleApiClient, metadataChangeSet, driveContents, zzh.zza(executionOptions));
    }

    private void zzb(MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        zzi zzi2 = zzi.zziu(metadataChangeSet.getMimeType());
        if (zzi2 != null && !zzi2.zzbdg()) {
            throw new IllegalArgumentException("May not create shortcut files using this method. Use DriveFolder.createShortcutFile() instead.");
        }
    }

    public PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, zzh zzh2) {
        if (zzh2 == null) {
            zzh2 = (zzh)new zzh.zza().build();
        }
        this.zzb(googleApiClient, metadataChangeSet, driveContents, zzh2);
        zzi zzi2 = zzi.zziu(metadataChangeSet.getMimeType());
        int n = this.zza(driveContents, zzi2);
        String string = zzh2.zzbbf();
        if (string != null) {
            metadataChangeSet = this.zza(metadataChangeSet, string);
        }
        return this.zza(googleApiClient, metadataChangeSet, n, zzh2);
    }

    private MetadataChangeSet zza(MetadataChangeSet metadataChangeSet, String string) {
        return metadataChangeSet.zza(zzsp.Mp, string);
    }

    private int zza(DriveContents driveContents, zzi zzi2) {
        int n;
        if (driveContents == null) {
            n = zzi2 != null && zzi2.zzbdh() ? 0 : 1;
        } else {
            n = driveContents.zzbaw().getRequestId();
            driveContents.zzbax();
        }
        return n;
    }

    private void zzb(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, zzh zzh2) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        zzi zzi2 = zzi.zziu(metadataChangeSet.getMimeType());
        if (zzi2 != null && zzi2.isFolder()) {
            throw new IllegalArgumentException("May not create folders using this method. Use DriveFolder.createFolder() instead of mime type application/vnd.google-apps.folder");
        }
        zzh2.zzh(googleApiClient);
        if (driveContents == null) {
            return;
        }
        if (!(driveContents instanceof zzv)) {
            throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
        }
        if (driveContents.getDriveId() != null) {
            throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
        }
        if (driveContents.zzbay()) {
            throw new IllegalArgumentException("DriveContents are already closed.");
        }
    }

    private PendingResult<DriveFolder.DriveFileResult> zza(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet, final int n, final zzh zzh2) {
        zzi zzi2 = zzi.zziu(metadataChangeSet.getMimeType());
        final int n2 = zzi2 != null && zzi2.zzbdh() ? 1 : 0;
        return googleApiClient.zzd((zzqc.zza)new zzd(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                metadataChangeSet.zzbbk().setContext(zzu2.getContext());
                CreateFileRequest createFileRequest = new CreateFileRequest(zzy.this.getDriveId(), metadataChangeSet.zzbbk(), n, n2, zzh2);
                zzu2.zzbcd().zza(createFileRequest, (zzan)new zza((zzqc.zzb<DriveFolder.DriveFileResult>)this));
            }
        });
    }

    @Override
    public PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient googleApiClient, final MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet == null) {
            throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        }
        if (metadataChangeSet.getMimeType() != null && !metadataChangeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return googleApiClient.zzd((zzqc.zza)new zzf(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                metadataChangeSet.zzbbk().setContext(zzu2.getContext());
                zzu2.zzbcd().zza(new CreateFolderRequest(zzy.this.getDriveId(), metadataChangeSet.zzbbk()), (zzan)new zzb((zzqc.zzb<DriveFolder.DriveFolderResult>)this));
            }
        });
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zzqc.zzb<DriveFolder.DriveFolderResult> Dj;

        public zzb(zzqc.zzb<DriveFolder.DriveFolderResult> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.Dj.setResult((Object)new zze(Status.vY, new zzy(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.Dj.setResult((Object)new zze(status, null));
        }
    }

    private static class zze
    implements DriveFolder.DriveFolderResult {
        private final Status fp;
        private final DriveFolder Kd;

        public zze(Status status, DriveFolder driveFolder) {
            this.fp = status;
            this.Kd = driveFolder;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public DriveFolder getDriveFolder() {
            return this.Kd;
        }
    }

    static abstract class zzf
    extends zzt<DriveFolder.DriveFolderResult> {
        zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFolderResult zzap(Status status) {
            return new zze(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzap(status);
        }
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zzqc.zzb<DriveFolder.DriveFileResult> Dj;

        public zza(zzqc.zzb<DriveFolder.DriveFileResult> zzb2) {
            this.Dj = zzb2;
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.Dj.setResult((Object)new zzc(Status.vY, new zzw(onDriveIdResponse.getDriveId())));
        }

        @Override
        public void onError(Status status) throws RemoteException {
            this.Dj.setResult((Object)new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveFolder.DriveFileResult {
        private final Status fp;
        private final DriveFile Kc;

        public zzc(Status status, DriveFile driveFile) {
            this.fp = status;
            this.Kc = driveFile;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public DriveFile getDriveFile() {
            return this.Kc;
        }
    }

    static abstract class zzd
    extends zzt<DriveFolder.DriveFileResult> {
        zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveFolder.DriveFileResult zzao(Status status) {
            return new zzc(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzao(status);
        }
    }
}

