/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.MetadataField;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzsp;
import com.google.android.gms.internal.zzsr;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet HM = new MetadataChangeSet(MetadataBundle.zzbdd());
    private final MetadataBundle HN;

    public MetadataChangeSet(MetadataBundle metadataBundle) {
        this.HN = metadataBundle.zzbde();
    }

    public Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.HN.zza(zzsp.LH);
        return appVisibleCustomProperties == null ? Collections.emptyMap() : appVisibleCustomProperties.zzbcy();
    }

    public String getDescription() {
        return this.HN.zza(zzsp.LI);
    }

    public String getIndexableText() {
        return this.HN.zza(zzsp.LO);
    }

    public Date getLastViewedByMeDate() {
        return this.HN.zza(zzsr.My);
    }

    public String getMimeType() {
        return this.HN.zza(zzsp.Mc);
    }

    public String getTitle() {
        return this.HN.zza(zzsp.Ml);
    }

    public Boolean isPinned() {
        return this.HN.zza(zzsp.LU);
    }

    public Boolean isStarred() {
        return this.HN.zza(zzsp.Mj);
    }

    public Boolean isViewed() {
        return this.HN.zza(zzsp.Mb);
    }

    public MetadataBundle zzbbk() {
        return this.HN;
    }

    public MetadataChangeSet zzbbl() {
        return new MetadataChangeSet(this.zzbbk());
    }

    public <T> MetadataChangeSet zza(MetadataField<T> metadataField, T t) {
        MetadataChangeSet metadataChangeSet = this.zzbbl();
        metadataChangeSet.zzbbk().zzc(metadataField, t);
        return metadataChangeSet;
    }

    public static class Builder {
        private final MetadataBundle HN = MetadataBundle.zzbdd();
        private AppVisibleCustomProperties.zza HO;

        private AppVisibleCustomProperties.zza zzbbm() {
            if (this.HO == null) {
                this.HO = new AppVisibleCustomProperties.zza();
            }
            return this.HO;
        }

        private int zzir(String string) {
            return string == null ? 0 : string.getBytes().length;
        }

        private String zzj(String string, int n, int n2) {
            return String.format("%s must be no more than %d bytes, but is %d bytes.", string, n, n2);
        }

        private void zzk(String string, int n, int n2) {
            zzac.zzb((n2 <= n ? 1 : 0) != 0, (Object)this.zzj(string, n, n2));
        }

        public Builder setCustomProperty(CustomPropertyKey customPropertyKey, String string) {
            zzac.zzb((Object)((Object)customPropertyKey), (Object)"key");
            zzac.zzb((Object)string, (Object)"value");
            int n = this.zzir(customPropertyKey.getKey()) + this.zzir(string);
            this.zzk("The total size of key string and value string of a custom property", 124, n);
            this.zzbbm().zza(customPropertyKey, string);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey customPropertyKey) {
            zzac.zzb((Object)((Object)customPropertyKey), (Object)"key");
            this.zzbbm().zza(customPropertyKey, null);
            return this;
        }

        public Builder setDescription(String string) {
            this.HN.zzc(zzsp.LI, string);
            return this;
        }

        public Builder setIndexableText(String string) {
            int n = this.zzir(string);
            this.zzk("Indexable text size", 131072, n);
            this.HN.zzc(zzsp.LO, string);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.HN.zzc(zzsr.My, date);
            return this;
        }

        public Builder setMimeType(String string) {
            this.HN.zzc(zzsp.Mc, string);
            return this;
        }

        public Builder setPinned(boolean bl) {
            this.HN.zzc(zzsp.LU, bl);
            return this;
        }

        public Builder setStarred(boolean bl) {
            this.HN.zzc(zzsp.Mj, bl);
            return this;
        }

        public Builder setTitle(String string) {
            this.HN.zzc(zzsp.Ml, string);
            return this;
        }

        public Builder setViewed(boolean bl) {
            this.HN.zzc(zzsp.Mb, bl);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.HO != null) {
                this.HN.zzc(zzsp.LH, this.HO.zzbcz());
            }
            return new MetadataChangeSet(this.HN);
        }
    }
}

