/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.internal.zzab;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.internal.zzz;
import com.google.android.gms.drive.zze;
import com.google.android.gms.internal.zzarj;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzsn;
import com.google.android.gms.internal.zzso;

public class DriveId
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zze();
    final int mVersionCode;
    final String Hu;
    final long Hv;
    final long Hd;
    final int Hw;
    private volatile String Hf = null;
    private volatile String Hx = null;

    public static DriveId zzin(String string) {
        zzac.zzy((Object)string);
        return new DriveId(string, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.Hu;
    }

    public int getResourceType() {
        return this.Hw;
    }

    public DriveFile asDriveFile() {
        if (this.Hw == 1) {
            throw new IllegalStateException("This DriveId corresponds to a folder. Call asDriveFolder instead.");
        }
        return new zzw(this);
    }

    public DriveFolder asDriveFolder() {
        if (this.Hw == 0) {
            throw new IllegalStateException("This DriveId corresponds to a file. Call asDriveFile instead.");
        }
        return new zzy(this);
    }

    public DriveResource asDriveResource() {
        if (this.Hw == 1) {
            return this.asDriveFolder();
        }
        if (this.Hw == 0) {
            return this.asDriveFile();
        }
        return new zzab(this);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    DriveId(int n, String string, long l, long l2, int n2) {
        this.mVersionCode = n;
        this.Hu = string;
        zzac.zzbs((!"".equals(string) ? 1 : 0) != 0);
        zzac.zzbs((string != null || l != -1L ? 1 : 0) != 0);
        this.Hv = l;
        this.Hd = l2;
        this.Hw = n2;
    }

    public DriveId(String string, long l, long l2, int n) {
        this(1, string, l, l2, n);
    }

    public int hashCode() {
        if (this.Hv == -1L) {
            return this.Hu.hashCode();
        }
        String string = String.valueOf(String.valueOf(this.Hd));
        String string2 = String.valueOf(String.valueOf(this.Hv));
        return (string2.length() != 0 ? string.concat(string2) : new String(string)).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)((Object)object);
        if (driveId.Hd != this.Hd) {
            return false;
        }
        if (driveId.Hv == -1L && this.Hv == -1L) {
            return driveId.Hu.equals(this.Hu);
        }
        if (this.Hu == null || driveId.Hu == null) {
            return driveId.Hv == this.Hv;
        }
        if (driveId.Hv == this.Hv) {
            if (driveId.Hu.equals(this.Hu)) {
                return true;
            }
            zzz.zzaf("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.Hf == null) {
            byte[] byArray = this.zzbat();
            String string = Base64.encodeToString((byte[])byArray, (int)10);
            String string2 = String.valueOf("DriveId:");
            String string3 = String.valueOf(string);
            this.Hf = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return this.Hf;
    }

    public final String toInvariantString() {
        if (this.Hx == null) {
            byte[] byArray = this.zzbaz();
            this.Hx = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.Hx;
    }

    final byte[] zzbat() {
        zzsn zzsn2 = new zzsn();
        zzsn2.versionCode = this.mVersionCode;
        zzsn2.Ln = this.Hu == null ? "" : this.Hu;
        zzsn2.Lo = this.Hv;
        zzsn2.Ll = this.Hd;
        zzsn2.Lp = this.Hw;
        byte[] byArray = zzark.zzf((zzark)zzsn2);
        return byArray;
    }

    private byte[] zzbaz() {
        zzso zzso2 = new zzso();
        zzso2.Lo = this.Hv;
        zzso2.Ll = this.Hd;
        byte[] byArray = zzark.zzf((zzark)zzso2);
        return byArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String string) {
        String string2 = String.valueOf(string);
        zzac.zzb((boolean)string.startsWith("DriveId:"), (Object)(string2.length() != 0 ? "Invalid DriveId: ".concat(string2) : new String("Invalid DriveId: ")));
        String string3 = string.substring("DriveId:".length());
        byte[] byArray = Base64.decode((String)string3, (int)10);
        return DriveId.zzs(byArray);
    }

    static DriveId zzs(byte[] byArray) {
        zzsn zzsn2;
        try {
            zzsn2 = zzsn.zzt(byArray);
        }
        catch (zzarj zzarj2) {
            throw new IllegalArgumentException();
        }
        String string = "".equals(zzsn2.Ln) ? null : zzsn2.Ln;
        DriveId driveId = new DriveId(zzsn2.versionCode, string, zzsn2.Lo, zzsn2.Ll, zzsn2.Lp);
        return driveId;
    }
}

