/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.stats;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsEntityCreator;

public class PlayerStatsEntity
extends AbstractSafeParcelable
implements PlayerStats {
    public static final Parcelable.Creator<PlayerStatsEntity> CREATOR = new PlayerStatsEntityCreator();
    private final int mVersionCode;
    private final float adU;
    private final float adV;
    private final int adW;
    private final int adX;
    private final int adY;
    private final float adZ;
    private final float aea;
    private final Bundle aeb;
    private final float aec;
    private final float aed;
    private final float aee;

    public PlayerStatsEntity(PlayerStats playerStats) {
        this.mVersionCode = 4;
        this.adU = playerStats.getAverageSessionLength();
        this.adV = playerStats.getChurnProbability();
        this.adW = playerStats.getDaysSinceLastPlayed();
        this.adX = playerStats.getNumberOfPurchases();
        this.adY = playerStats.getNumberOfSessions();
        this.adZ = playerStats.getSessionPercentile();
        this.aea = playerStats.getSpendPercentile();
        this.aec = playerStats.getSpendProbability();
        this.aed = playerStats.getHighSpenderProbability();
        this.aee = playerStats.getTotalSpendNext28Days();
        this.aeb = playerStats.zzbnj();
    }

    PlayerStatsEntity(int n, float f, float f2, int n2, int n3, int n4, float f3, float f4, Bundle bundle, float f5, float f6, float f7) {
        this.mVersionCode = n;
        this.adU = f;
        this.adV = f2;
        this.adW = n2;
        this.adX = n3;
        this.adY = n4;
        this.adZ = f3;
        this.aea = f4;
        this.aeb = bundle;
        this.aec = f5;
        this.aed = f6;
        this.aee = f7;
    }

    @Override
    public float getAverageSessionLength() {
        return this.adU;
    }

    @Override
    public float getChurnProbability() {
        return this.adV;
    }

    @Override
    public int getDaysSinceLastPlayed() {
        return this.adW;
    }

    @Override
    public int getNumberOfPurchases() {
        return this.adX;
    }

    @Override
    public int getNumberOfSessions() {
        return this.adY;
    }

    @Override
    public float getSessionPercentile() {
        return this.adZ;
    }

    @Override
    public float getSpendPercentile() {
        return this.aea;
    }

    @Override
    public Bundle zzbnj() {
        return this.aeb;
    }

    @Override
    public float getSpendProbability() {
        return this.aec;
    }

    @Override
    public float getHighSpenderProbability() {
        return this.aed;
    }

    @Override
    public float getTotalSpendNext28Days() {
        return this.aee;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public PlayerStats zzbnk() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerStatsEntity.zza(this);
    }

    static int zza(PlayerStats playerStats) {
        return zzab.hashCode((Object[])new Object[]{Float.valueOf(playerStats.getAverageSessionLength()), Float.valueOf(playerStats.getChurnProbability()), playerStats.getDaysSinceLastPlayed(), playerStats.getNumberOfPurchases(), playerStats.getNumberOfSessions(), Float.valueOf(playerStats.getSessionPercentile()), Float.valueOf(playerStats.getSpendPercentile()), Float.valueOf(playerStats.getSpendProbability()), Float.valueOf(playerStats.getHighSpenderProbability()), Float.valueOf(playerStats.getTotalSpendNext28Days())});
    }

    public boolean equals(Object object) {
        return PlayerStatsEntity.zza(this, object);
    }

    static boolean zza(PlayerStats playerStats, Object object) {
        if (!(object instanceof PlayerStats)) {
            return false;
        }
        if (playerStats == object) {
            return true;
        }
        PlayerStats playerStats2 = (PlayerStats)object;
        return zzab.equal((Object)Float.valueOf(playerStats2.getAverageSessionLength()), (Object)Float.valueOf(playerStats.getAverageSessionLength())) && zzab.equal((Object)Float.valueOf(playerStats2.getChurnProbability()), (Object)Float.valueOf(playerStats.getChurnProbability())) && zzab.equal((Object)playerStats2.getDaysSinceLastPlayed(), (Object)playerStats.getDaysSinceLastPlayed()) && zzab.equal((Object)playerStats2.getNumberOfPurchases(), (Object)playerStats.getNumberOfPurchases()) && zzab.equal((Object)playerStats2.getNumberOfSessions(), (Object)playerStats.getNumberOfSessions()) && zzab.equal((Object)Float.valueOf(playerStats2.getSessionPercentile()), (Object)Float.valueOf(playerStats.getSessionPercentile())) && zzab.equal((Object)Float.valueOf(playerStats2.getSpendPercentile()), (Object)Float.valueOf(playerStats.getSpendPercentile())) && zzab.equal((Object)Float.valueOf(playerStats2.getSpendProbability()), (Object)Float.valueOf(playerStats.getSpendProbability())) && zzab.equal((Object)Float.valueOf(playerStats2.getHighSpenderProbability()), (Object)Float.valueOf(playerStats.getHighSpenderProbability())) && zzab.equal((Object)Float.valueOf(playerStats2.getTotalSpendNext28Days()), (Object)Float.valueOf(playerStats.getTotalSpendNext28Days()));
    }

    public String toString() {
        return PlayerStatsEntity.zzb(this);
    }

    static String zzb(PlayerStats playerStats) {
        return zzab.zzx((Object)playerStats).zzg("AverageSessionLength", (Object)Float.valueOf(playerStats.getAverageSessionLength())).zzg("ChurnProbability", (Object)Float.valueOf(playerStats.getChurnProbability())).zzg("DaysSinceLastPlayed", (Object)playerStats.getDaysSinceLastPlayed()).zzg("NumberOfPurchases", (Object)playerStats.getNumberOfPurchases()).zzg("NumberOfSessions", (Object)playerStats.getNumberOfSessions()).zzg("SessionPercentile", (Object)Float.valueOf(playerStats.getSessionPercentile())).zzg("SpendPercentile", (Object)Float.valueOf(playerStats.getSpendPercentile())).zzg("SpendProbability", (Object)Float.valueOf(playerStats.getSpendProbability())).zzg("HighSpenderProbability", (Object)Float.valueOf(playerStats.getHighSpenderProbability())).zzg("TotalSpendNext28Days", (Object)Float.valueOf(playerStats.getTotalSpendNext28Days())).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerStatsEntityCreator.zza(this, parcel, n);
    }

    public /* synthetic */ Object freeze() {
        return this.zzbnk();
    }
}

