/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
extends AbstractSafeParcelable
implements Milestone {
    public static final Parcelable.Creator<MilestoneEntity> CREATOR = new MilestoneEntityCreator();
    private final int mVersionCode;
    private final String XO;
    private final long adi;
    private final long adj;
    private final byte[] adk;
    private final int mState;
    private final String Wz;

    public MilestoneEntity(Milestone milestone) {
        this.mVersionCode = 4;
        this.XO = milestone.getMilestoneId();
        this.adi = milestone.getCurrentProgress();
        this.adj = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.Wz = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.adk = null;
        } else {
            this.adk = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.adk, 0, byArray.length);
        }
    }

    MilestoneEntity(int n, String string, long l, long l2, byte[] byArray, int n2, String string2) {
        this.mVersionCode = n;
        this.XO = string;
        this.adi = l;
        this.adj = l2;
        this.adk = byArray;
        this.mState = n2;
        this.Wz = string2;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.Wz;
    }

    @Override
    public String getMilestoneId() {
        return this.XO;
    }

    @Override
    public long getCurrentProgress() {
        return this.adi;
    }

    @Override
    public long getTargetProgress() {
        return this.adj;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.adk;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Milestone freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return zzab.hashCode((Object[])new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public boolean equals(Object object) {
        return MilestoneEntity.zza(this, object);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzab.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzab.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzab.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzab.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzab.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzab.zzx((Object)milestone).zzg("MilestoneId", (Object)milestone.getMilestoneId()).zzg("CurrentProgress", (Object)milestone.getCurrentProgress()).zzg("TargetProgress", (Object)milestone.getTargetProgress()).zzg("State", (Object)milestone.getState()).zzg("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zzg("EventId", (Object)milestone.getEventId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        MilestoneEntityCreator.zza(this, parcel, n);
    }
}

