/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
extends AbstractSafeParcelable
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new TurnBasedMatchEntityCreator();
    private final int mVersionCode;
    private final GameEntity aaK;
    private final String XD;
    private final String acQ;
    private final long acu;
    private final String acY;
    private final long Wa;
    private final String acZ;
    private final int ada;
    private final int acy;
    private final int mVersion;
    private final byte[] adb;
    private final ArrayList<ParticipantEntity> acx;
    private final String adc;
    private final byte[] add;
    private final int ade;
    private final Bundle acO;
    private final int adf;
    private final boolean adg;
    private final String Y;
    private final String adh;

    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.mVersionCode = 2;
        this.aaK = new GameEntity(turnBasedMatch.getGame());
        this.XD = turnBasedMatch.getMatchId();
        this.acQ = turnBasedMatch.getCreatorId();
        this.acu = turnBasedMatch.getCreationTimestamp();
        this.acY = turnBasedMatch.getLastUpdaterId();
        this.Wa = turnBasedMatch.getLastUpdatedTimestamp();
        this.acZ = turnBasedMatch.getPendingParticipantId();
        this.ada = turnBasedMatch.getStatus();
        this.adf = turnBasedMatch.getTurnStatus();
        this.acy = turnBasedMatch.getVariant();
        this.mVersion = turnBasedMatch.getVersion();
        this.adc = turnBasedMatch.getRematchId();
        this.ade = turnBasedMatch.getMatchNumber();
        this.acO = turnBasedMatch.getAutoMatchCriteria();
        this.adg = turnBasedMatch.isLocallyModified();
        this.Y = turnBasedMatch.getDescription();
        this.adh = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.adb = null;
        } else {
            this.adb = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.adb, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.add = null;
        } else {
            this.add = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.add, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.acx = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.acx.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int n, GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n2, int n3, int n4, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n5, Bundle bundle, int n6, boolean bl, String string6, String string7) {
        this.mVersionCode = n;
        this.aaK = gameEntity;
        this.XD = string;
        this.acQ = string2;
        this.acu = l;
        this.acY = string3;
        this.Wa = l2;
        this.acZ = string4;
        this.ada = n2;
        this.adf = n6;
        this.acy = n3;
        this.mVersion = n4;
        this.adb = byArray;
        this.acx = arrayList;
        this.adc = string5;
        this.add = byArray2;
        this.ade = n5;
        this.acO = bundle;
        this.adg = bl;
        this.Y = string6;
        this.adh = string7;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.aaK;
    }

    @Override
    public String getMatchId() {
        return this.XD;
    }

    @Override
    public String getCreatorId() {
        return this.acQ;
    }

    @Override
    public long getCreationTimestamp() {
        return this.acu;
    }

    @Override
    public String getLastUpdaterId() {
        return this.acY;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Wa;
    }

    @Override
    public String getPendingParticipantId() {
        return this.acZ;
    }

    @Override
    public int getStatus() {
        return this.ada;
    }

    @Override
    public int getTurnStatus() {
        return this.adf;
    }

    @Override
    public String getDescription() {
        return this.Y;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.adh;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Y, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public int getVariant() {
        return this.acy;
    }

    @Override
    public byte[] getData() {
        return this.adb;
    }

    @Override
    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String getRematchId() {
        return this.adc;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.add;
    }

    @Override
    public int getMatchNumber() {
        return this.ade;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.acO;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.acO == null) {
            return 0;
        }
        return this.acO.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.ada == 2 && this.adc == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.adg;
    }

    @Override
    public int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.acx);
    }

    public TurnBasedMatch freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzab.hashCode((Object[])new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzab.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzab.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzab.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzab.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzab.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzab.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzab.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzab.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzab.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzab.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzab.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzab.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzab.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzab.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzab.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzab.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzab.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzab.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzab.zzx((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        TurnBasedMatchEntityCreator.zza(this, parcel, n);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

