/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int mVersionCode;
    private final String Xi;
    private final String acQ;
    private final long acu;
    private final int acR;
    private final String Y;
    private final int acy;
    private final Bundle acO;
    private final ArrayList<ParticipantEntity> acx;
    private final int acS;

    public RoomEntity(Room room) {
        this.mVersionCode = 2;
        this.Xi = room.getRoomId();
        this.acQ = room.getCreatorId();
        this.acu = room.getCreationTimestamp();
        this.acR = room.getStatus();
        this.Y = room.getDescription();
        this.acy = room.getVariant();
        this.acO = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.acx = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.acx.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.acS = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int n, String string, String string2, long l, int n2, String string3, int n3, Bundle bundle, ArrayList<ParticipantEntity> arrayList, int n4) {
        this.mVersionCode = n;
        this.Xi = string;
        this.acQ = string2;
        this.acu = l;
        this.acR = n2;
        this.Y = string3;
        this.acy = n3;
        this.acO = bundle;
        this.acx = arrayList;
        this.acS = n4;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRoomId() {
        return this.Xi;
    }

    @Override
    public String getCreatorId() {
        return this.acQ;
    }

    @Override
    public long getCreationTimestamp() {
        return this.acu;
    }

    @Override
    public int getStatus() {
        return this.acR;
    }

    @Override
    public String getDescription() {
        return this.Y;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Y, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public int getVariant() {
        return this.acy;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.acO;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.acx);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.acS;
    }

    @Override
    public int getParticipantStatus(String string) {
        return RoomEntity.zza((Room)this, string);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String string) {
        return RoomEntity.zzb(this, string);
    }

    @Override
    public Participant getParticipant(String string) {
        return RoomEntity.zzc(this, string);
    }

    public Room freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return zzab.hashCode((Object[])new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public boolean equals(Object object) {
        return RoomEntity.zza((Room)this, object);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzab.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzab.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzab.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzab.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzab.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzab.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzab.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzab.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzab.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzab.zzx((Object)room).zzg("RoomId", (Object)room.getRoomId()).zzg("CreatorId", (Object)room.getCreatorId()).zzg("CreationTimestamp", (Object)room.getCreationTimestamp()).zzg("RoomStatus", (Object)room.getStatus()).zzg("Description", (Object)room.getDescription()).zzg("Variant", (Object)room.getVariant()).zzg("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zzg("Participants", (Object)room.getParticipants()).zzg("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzaur()) {
            RoomEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.Xi);
            parcel.writeString(this.acQ);
            parcel.writeLong(this.acu);
            parcel.writeInt(this.acR);
            parcel.writeString(this.Y);
            parcel.writeInt(this.acy);
            parcel.writeBundle(this.acO);
            int n2 = this.acx.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.acx.get(i).writeToParcel(parcel, n);
            }
        }
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = String.valueOf(room.getRoomId());
        throw new IllegalStateException(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in room ").append(string2).toString());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = String.valueOf(room.getRoomId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity zzmg(Parcel parcel) {
            int n;
            boolean bl = RoomEntity.zzf(RoomEntity.zzauq());
            if (bl || RoomEntity.zzhs((String)RoomEntity.class.getCanonicalName())) {
                return super.zzmg(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n = 0; n < n4; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            return new RoomEntity(2, string, string2, l, n2, string3, n3, bundle, arrayList, -1);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzmg(parcel);
        }
    }
}

