/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String abP;
    private final String gV;
    private final Uri UJ;
    private final int abQ;
    private final ArrayList<LeaderboardVariantEntity> abR;
    private final Game abS;
    private final String UU;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.abP = leaderboard.getLeaderboardId();
        this.gV = leaderboard.getDisplayName();
        this.UJ = leaderboard.getIconImageUri();
        this.UU = leaderboard.getIconImageUrl();
        this.abQ = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.abS = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.abR = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.abR.add((LeaderboardVariantEntity)arrayList.get(i).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.abP;
    }

    @Override
    public String getDisplayName() {
        return this.gV;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.gV, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.UJ;
    }

    @Override
    public String getIconImageUrl() {
        return this.UU;
    }

    @Override
    public int getScoreOrder() {
        return this.abQ;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.abR);
    }

    @Override
    public Game getGame() {
        return this.abS;
    }

    public Leaderboard zzbmu() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return zzab.hashCode((Object[])new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public boolean equals(Object object) {
        return LeaderboardEntity.zza(this, object);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzab.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzab.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzab.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzab.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzab.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzab.zzx((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzbmu();
    }
}

