/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;

public final class EventEntity
extends AbstractSafeParcelable
implements Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int mVersionCode;
    private final String Wz;
    private final String mName;
    private final String Y;
    private final Uri UJ;
    private final String UU;
    private final PlayerEntity VX;
    private final long X;
    private final String WA;
    private final boolean zzast;

    public EventEntity(Event event) {
        this.mVersionCode = 1;
        this.Wz = event.getEventId();
        this.mName = event.getName();
        this.Y = event.getDescription();
        this.UJ = event.getIconImageUri();
        this.UU = event.getIconImageUrl();
        this.VX = (PlayerEntity)event.getPlayer().freeze();
        this.X = event.getValue();
        this.WA = event.getFormattedValue();
        this.zzast = event.isVisible();
    }

    EventEntity(int n, String string, String string2, String string3, Uri uri, String string4, Player player, long l, String string5, boolean bl) {
        this.mVersionCode = n;
        this.Wz = string;
        this.mName = string2;
        this.Y = string3;
        this.UJ = uri;
        this.UU = string4;
        this.VX = new PlayerEntity(player);
        this.X = l;
        this.WA = string5;
        this.zzast = bl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.Wz;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.Y;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Y, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.UJ;
    }

    @Override
    public String getIconImageUrl() {
        return this.UU;
    }

    @Override
    public Player getPlayer() {
        return this.VX;
    }

    @Override
    public long getValue() {
        return this.X;
    }

    @Override
    public String getFormattedValue() {
        return this.WA;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.WA, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public boolean isVisible() {
        return this.zzast;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzab.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object object) {
        return EventEntity.zza(this, object);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzab.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzab.equal((Object)event2.getName(), (Object)event.getName()) && zzab.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzab.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzab.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzab.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzab.equal((Object)event2.getValue(), (Object)event.getValue()) && zzab.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzab.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzab.zzx((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        EventEntityCreator.zza(this, parcel, n);
    }
}

