/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int mVersionCode;
    private final String jM;
    private final String gV;
    private final String UG;
    private final String UH;
    private final String Y;
    private final String UI;
    private final Uri UJ;
    private final Uri UK;
    private final Uri UL;
    private final boolean UM;
    private final boolean UN;
    private final String UO;
    private final int UP;
    private final int UQ;
    private final int UR;
    private final boolean US;
    private final boolean UT;
    private final String UU;
    private final String UV;
    private final String UW;
    private final boolean zzbwv;
    private final boolean UX;
    private final boolean UY;
    private final String UZ;
    private final boolean Va;

    public GameEntity(Game game) {
        this.mVersionCode = 7;
        this.jM = game.getApplicationId();
        this.UG = game.getPrimaryCategory();
        this.UH = game.getSecondaryCategory();
        this.Y = game.getDescription();
        this.UI = game.getDeveloperName();
        this.gV = game.getDisplayName();
        this.UJ = game.getIconImageUri();
        this.UU = game.getIconImageUrl();
        this.UK = game.getHiResImageUri();
        this.UV = game.getHiResImageUrl();
        this.UL = game.getFeaturedImageUri();
        this.UW = game.getFeaturedImageUrl();
        this.UM = game.zzbhr();
        this.UN = game.zzbht();
        this.UO = game.zzbhu();
        this.UP = 1;
        this.UQ = game.getAchievementTotalCount();
        this.UR = game.getLeaderboardCount();
        this.US = game.isRealTimeMultiplayerEnabled();
        this.UT = game.isTurnBasedMultiplayerEnabled();
        this.zzbwv = game.isMuted();
        this.UX = game.zzbhs();
        this.UY = game.areSnapshotsEnabled();
        this.UZ = game.getThemeColor();
        this.Va = game.hasGamepadSupport();
    }

    GameEntity(int n, String string, String string2, String string3, String string4, String string5, String string6, Uri uri, Uri uri2, Uri uri3, boolean bl, boolean bl2, String string7, int n2, int n3, int n4, boolean bl3, boolean bl4, String string8, String string9, String string10, boolean bl5, boolean bl6, boolean bl7, String string11, boolean bl8) {
        this.mVersionCode = n;
        this.jM = string;
        this.gV = string2;
        this.UG = string3;
        this.UH = string4;
        this.Y = string5;
        this.UI = string6;
        this.UJ = uri;
        this.UU = string8;
        this.UK = uri2;
        this.UV = string9;
        this.UL = uri3;
        this.UW = string10;
        this.UM = bl;
        this.UN = bl2;
        this.UO = string7;
        this.UP = n2;
        this.UQ = n3;
        this.UR = n4;
        this.US = bl3;
        this.UT = bl4;
        this.zzbwv = bl5;
        this.UX = bl6;
        this.UY = bl7;
        this.UZ = string11;
        this.Va = bl8;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getApplicationId() {
        return this.jM;
    }

    @Override
    public String getDisplayName() {
        return this.gV;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.gV, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getPrimaryCategory() {
        return this.UG;
    }

    @Override
    public String getSecondaryCategory() {
        return this.UH;
    }

    @Override
    public String getDescription() {
        return this.Y;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Y, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDeveloperName() {
        return this.UI;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.UI, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.UJ;
    }

    @Override
    public String getIconImageUrl() {
        return this.UU;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.UK;
    }

    @Override
    public String getHiResImageUrl() {
        return this.UV;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.UL;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.UW;
    }

    @Override
    public boolean isMuted() {
        return this.zzbwv;
    }

    @Override
    public boolean zzbhs() {
        return this.UX;
    }

    @Override
    public boolean zzbhr() {
        return this.UM;
    }

    @Override
    public boolean zzbht() {
        return this.UN;
    }

    @Override
    public String zzbhu() {
        return this.UO;
    }

    public int zzbhv() {
        return this.UP;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.UQ;
    }

    @Override
    public int getLeaderboardCount() {
        return this.UR;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.US;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.UT;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.UY;
    }

    @Override
    public String getThemeColor() {
        return this.UZ;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.Va;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzab.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzbhr(), game.zzbht(), game.zzbhu(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzbhs(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzab.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzab.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzab.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzab.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzab.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzab.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzab.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzab.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzab.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzab.equal((Object)game2.zzbhr(), (Object)game.zzbhr()) && zzab.equal((Object)game2.zzbht(), (Object)game.zzbht()) && zzab.equal((Object)game2.zzbhu(), (Object)game.zzbhu()) && zzab.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzab.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzab.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzab.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzab.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzab.equal((Object)game2.zzbhs(), (Object)game.zzbhs()) ? 1 : 0)) && zzab.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzab.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzab.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzab.zzx((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzbhr()).zzg("InstanceInstalled", (Object)game.zzbht()).zzg("InstancePackageName", (Object)game.zzbhu()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzaur()) {
            GameEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.jM);
            parcel.writeString(this.gV);
            parcel.writeString(this.UG);
            parcel.writeString(this.UH);
            parcel.writeString(this.Y);
            parcel.writeString(this.UI);
            parcel.writeString(this.UJ == null ? null : this.UJ.toString());
            parcel.writeString(this.UK == null ? null : this.UK.toString());
            parcel.writeString(this.UL == null ? null : this.UL.toString());
            parcel.writeInt(this.UM ? 1 : 0);
            parcel.writeInt(this.UN ? 1 : 0);
            parcel.writeString(this.UO);
            parcel.writeInt(this.UP);
            parcel.writeInt(this.UQ);
            parcel.writeInt(this.UR);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzli(Parcel parcel) {
            boolean bl = GameEntity.zzf(GameEntity.zzauq());
            if (bl || GameEntity.zzhs((String)GameEntity.class.getCanonicalName())) {
                return super.zzli(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            Object var23_23 = null;
            Object var24_24 = null;
            Object var25_25 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            Object var29_29 = null;
            boolean bl9 = false;
            return new GameEntity(7, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, false, false, null, null, null, false, false, false, null, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzli(parcel);
        }
    }
}

