/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.zzd;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.internal.zzbw;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zzse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public class zze {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    public static final String KEY_CALLER_UID = Build.VERSION.SDK_INT >= 11 ? "callerUid" : "callerUid";
    public static final String KEY_ANDROID_PACKAGE_NAME = Build.VERSION.SDK_INT >= 14 ? "androidPackageName" : "androidPackageName";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName fw = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final ComponentName fx = new ComponentName("com.google.android.gms", "com.google.android.gms.recovery.RecoveryService");
    private static final zzse fy = zzd.zzb("GoogleAuthUtil");

    @Deprecated
    public static String getToken(Context context, String string, String string2) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return zze.getToken(context, account, string2);
    }

    @Deprecated
    public static String getToken(Context context, String string, String string2, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return zze.getToken(context, account, string2, bundle);
    }

    public static String getToken(Context context, Account account, String string) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zze.getToken(context, account, string, new Bundle());
    }

    public static String getToken(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        TokenData tokenData = zze.zzc(context, account, string, bundle);
        return tokenData.getToken();
    }

    public static TokenData zzc(Context context, final Account account, final String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        zzac.zzhr((String)"Calling this from your main thread can lead to deadlock");
        zzac.zzh((String)string, (Object)"Scope cannot be empty or null.");
        zzac.zzb((Object)account, (Object)"Account cannot be null.");
        zze.zzbc(context);
        final Bundle bundle2 = bundle == null ? new Bundle() : new Bundle(bundle);
        String string2 = context.getApplicationInfo().packageName;
        bundle2.putString("clientPackageName", string2);
        if (TextUtils.isEmpty((CharSequence)bundle2.getString(KEY_ANDROID_PACKAGE_NAME))) {
            bundle2.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        bundle2.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
        zza<TokenData> zza2 = new zza<TokenData>(){

            public TokenData zzbt(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzbw zzbw2 = zzbw.zza.zza(iBinder);
                Bundle bundle = (Bundle)zze.zzn(zzbw2.zza(account, string, bundle2));
                TokenData tokenData = TokenData.zzd(bundle, "tokenDetails");
                if (tokenData != null) {
                    return tokenData;
                }
                String string3 = bundle.getString("Error");
                Intent intent = (Intent)bundle.getParcelable("userRecoveryIntent");
                zznu zznu2 = zznu.zzgf(string3);
                if (zznu.zza(zznu2)) {
                    Object[] objectArray = new Object[1];
                    String string2 = String.valueOf((Object)zznu2);
                    objectArray[0] = new StringBuilder(31 + String.valueOf(string2).length()).append("isUserRecoverableError status: ").append(string2).toString();
                    fy.zzf("GoogleAuthUtil", objectArray);
                    throw new UserRecoverableAuthException(string3, intent);
                }
                if (zznu.zzb(zznu2)) {
                    throw new IOException(string3);
                }
                throw new GoogleAuthException(string3);
            }

            @Override
            public /* synthetic */ Object zzbu(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzbt(iBinder);
            }
        };
        return zze.zza(context, fw, zza2);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String string) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, string);
    }

    public static void clearToken(Context context, final String string) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        zzac.zzhr((String)"Calling this from your main thread can lead to deadlock");
        zze.zzbc(context);
        final Bundle bundle = new Bundle();
        String string2 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string2);
        if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
            bundle.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        zza<Void> zza2 = new zza<Void>(){

            public Void zzbv(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzbw zzbw2 = zzbw.zza.zza(iBinder);
                Bundle bundle2 = (Bundle)zze.zzn(zzbw2.zza(string, bundle));
                String string2 = bundle2.getString("Error");
                if (!bundle2.getBoolean("booleanResult")) {
                    throw new GoogleAuthException(string2);
                }
                return null;
            }

            @Override
            public /* synthetic */ Object zzbu(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzbv(iBinder);
            }
        };
        zze.zza(context, fw, zza2);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, final int n, final String string) throws GoogleAuthException, IOException {
        zzac.zzh((String)string, (Object)"accountName must be provided");
        zzac.zzhr((String)"Calling this from your main thread can lead to deadlock");
        zze.zzbc(context);
        zza<List<AccountChangeEvent>> zza2 = new zza<List<AccountChangeEvent>>(){

            public List<AccountChangeEvent> zzbw(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzbw zzbw2 = zzbw.zza.zza(iBinder);
                AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest().setAccountName(string).setEventIndex(n);
                AccountChangeEventsResponse accountChangeEventsResponse = (AccountChangeEventsResponse)((Object)zze.zzn((Object)zzbw2.zza(accountChangeEventsRequest)));
                return accountChangeEventsResponse.getEvents();
            }

            @Override
            public /* synthetic */ Object zzbu(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzbw(iBinder);
            }
        };
        return zze.zza(context, fw, zza2);
    }

    public static String getAccountId(Context context, String string) throws GoogleAuthException, IOException {
        zzac.zzh((String)string, (Object)"accountName must be provided");
        zzac.zzhr((String)"Calling this from your main thread can lead to deadlock");
        zze.zzbc(context);
        return zze.getToken(context, string, "^^_account_id_^^", new Bundle());
    }

    @TargetApi(value=23)
    public static Bundle removeAccount(Context context, final Account account) throws GoogleAuthException, IOException {
        zzac.zzy((Object)context);
        zzac.zzb((Object)account, (Object)"Account cannot be null.");
        zze.zzbc(context);
        zza<Bundle> zza2 = new zza<Bundle>(){

            public Bundle zzbx(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzbw zzbw2 = zzbw.zza.zza(iBinder);
                return (Bundle)zze.zzn(zzbw2.zza(account));
            }

            @Override
            public /* synthetic */ Object zzbu(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzbx(iBinder);
            }
        };
        return zze.zza(context, fw, zza2);
    }

    static void zzi(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Callback cannot be null.");
        }
        String string = intent.toUri(1);
        try {
            Intent.parseUri((String)string, (int)1);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    private static void zzbc(Context context) throws GoogleAuthException {
        try {
            com.google.android.gms.common.zze.zzbc((Context)context.getApplicationContext());
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static <T> T zzn(T t) throws IOException {
        if (t == null) {
            fy.zzf("GoogleAuthUtil", new Object[]{"Binder call returned null."});
            throw new IOException("Service unavailable.");
        }
        return t;
    }

    private static <T> T zza(Context context, ComponentName componentName, zza<T> zza2) throws IOException, GoogleAuthException {
        com.google.android.gms.common.zza zza3 = new com.google.android.gms.common.zza();
        zzn zzn2 = zzn.zzcf((Context)context);
        if (zzn2.zza(componentName, (ServiceConnection)zza3, "GoogleAuthUtil")) {
            try {
                T t = zza2.zzbu(zza3.zzapc());
                return t;
            }
            catch (RemoteException | InterruptedException throwable) {
                fy.zze("GoogleAuthUtil", new Object[]{"Error on service connection.", throwable});
                throw new IOException("Error on service connection.", throwable);
            }
            finally {
                zzn2.zzb(componentName, (ServiceConnection)zza3, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service.");
    }

    zze() {
    }

    private static interface zza<T> {
        public T zzbu(IBinder var1) throws RemoteException, IOException, GoogleAuthException;
    }
}

