/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzagm;
import com.google.android.gms.internal.zzago;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzagt;
import com.google.android.gms.internal.zzagv;
import com.google.android.gms.internal.zzagw;
import com.google.android.gms.internal.zzaha;
import com.google.android.gms.internal.zzahb;
import com.google.android.gms.internal.zzahc;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzahh;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzro;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.model.GetAccountInfoUser;
import com.google.firebase.auth.api.model.ProviderUserInfo;
import com.google.firebase.auth.api.model.VerifyAssertionRequest;
import java.util.ArrayList;
import java.util.List;

public class zzagl
extends com.google.android.gms.common.api.zzd<zzagt.zza> {
    zzagl(@NonNull Context context, @NonNull zzagt.zza zza2) {
        super(context, zzagt.aUg, (Api.ApiOptions)zza2);
    }

    public Task<GetTokenResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzaha zzaha2) {
        return this.zza(this.zza(new zzd(string).zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzo(string).zze(firebaseApp).zzbe(zzaha2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzn(authCredential).zze(firebaseApp).zzbe(zzaha2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzh(authCredential).zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzm().zze(firebaseApp).zzbe(zzaha2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzu(userProfileChangeRequest).zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzs(string).zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzt(string).zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zza(string, string2).zze(firebaseApp).zzbe(zzaha2)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzp(string, string2).zze(firebaseApp).zzbe(zzaha2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzi(string, string2).zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    public Task<ProviderQueryResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zza(this.zza(new zzc(string).zze(firebaseApp)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(this.zza(new zzl(string).zze(firebaseApp)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(this.zza(new zzk(string).zze(firebaseApp)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzaha zzaha2) {
        zzac.zzy((Object)firebaseApp);
        zzac.zzy((Object)authCredential);
        zzac.zzy((Object)firebaseUser);
        zzac.zzy((Object)zzaha2);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            return this.zza(firebaseApp, (EmailAuthCredential)authCredential, firebaseUser, zzaha2);
        }
        return this.zza(firebaseApp, authCredential, firebaseUser, zzaha2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull EmailAuthCredential emailAuthCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zze(emailAuthCredential).zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzaha zzaha2) {
        zzac.zzy((Object)firebaseApp);
        zzac.zzy((Object)authCredential);
        zzac.zzy((Object)firebaseUser);
        zzac.zzy((Object)zzaha2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && list.contains(authCredential.getProvider())) {
            return Tasks.forException((Exception)zzago.zzew(new Status(17015)));
        }
        return this.zzb(this.zza(new zzf(authCredential).zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    public Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzaha zzaha2) {
        zzac.zzy((Object)firebaseApp);
        zzac.zzhz((String)string);
        zzac.zzy((Object)firebaseUser);
        zzac.zzy((Object)zzaha2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && !list.contains(string) || firebaseUser.isAnonymous()) {
            return Tasks.forException((Exception)zzago.zzew(new Status(17016, string)));
        }
        switch (string) {
            case "password": {
                return this.zza(firebaseApp, firebaseUser, zzaha2);
            }
        }
        return this.zza(firebaseApp, string, firebaseUser, zzaha2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzq().zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull FirebaseUser firebaseUser, @NonNull zzaha zzaha2) {
        return this.zzb(this.zza(new zzr(string).zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzaha zzaha2) {
        return this.zza(this.zza(new zzj().zze(firebaseApp).zze(firebaseUser).zzbe(zzaha2)));
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull zzahi zzahi2) {
        return this.zzb(this.zza(new zzb().zze(firebaseUser).zzbe(zzahi2)));
    }

    @NonNull
    private static zzahf zza(@NonNull FirebaseApp firebaseApp, @NonNull GetAccountInfoUser getAccountInfoUser) {
        return zzagl.zza(firebaseApp, getAccountInfoUser, false);
    }

    @NonNull
    private static zzahf zza(@NonNull FirebaseApp firebaseApp, @NonNull GetAccountInfoUser getAccountInfoUser, boolean bl) {
        zzac.zzy((Object)firebaseApp);
        zzac.zzy((Object)getAccountInfoUser);
        ArrayList<zzahd> arrayList = new ArrayList<zzahd>();
        zzahd zzahd2 = new zzahd(getAccountInfoUser, "firebase");
        arrayList.add(zzahd2);
        List list = getAccountInfoUser.zzcpp();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(new zzahd((ProviderUserInfo)list.get(i)));
            }
        }
        zzahf zzahf2 = new zzahf(firebaseApp, arrayList);
        zzahf cfr_ignored_0 = (zzahf)zzahf2.zzcs(bl);
        return zzahf2;
    }

    private <ResultT, CallbackT> zzg<ResultT, CallbackT> zza(zzagw<ResultT, CallbackT> zzagw2) {
        return new zzg<ResultT, CallbackT>(zzagw2);
    }

    private class zzg<ResultT, CallbackT>
    extends zzro<zzagm, ResultT>
    implements zzagv<ResultT> {
        private zzagw<ResultT, CallbackT> aTY;
        private TaskCompletionSource<ResultT> wh;

        public zzg(zzagw<ResultT, CallbackT> zzagw2) {
            this.aTY = zzagw2;
            this.aTY.zza(this);
        }

        protected void zza(zzagm zzagm2, TaskCompletionSource<ResultT> taskCompletionSource) throws RemoteException {
            this.wh = taskCompletionSource;
            this.aTY.zza(zzagm2.zzcpe());
        }

        @Override
        public final void zza(ResultT ResultT, Status status) {
            zzac.zzb(this.wh, (Object)"doExecute must be called before onComplete");
            if (status != null) {
                this.wh.setException((Exception)zzago.zzew(status));
            } else {
                this.wh.setResult(ResultT);
            }
        }

        protected /* synthetic */ void zzb(Api.zzb zzb2, TaskCompletionSource taskCompletionSource) throws RemoteException {
            this.zza((zzagm)zzb2, taskCompletionSource);
        }
    }

    static final class zzb
    extends zzagw<Void, zzahi> {
        public zzb() {
            super(5);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zzg(this.aUj.zzcow(), this.aUi);
        }

        @Override
        public void zzcpd() {
            ((zzahi)this.aUl).zzcot();
            this.zzbf(null);
        }
    }

    static final class zzj
    extends zzagw<Void, zzaha> {
        public zzj() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zzf(this.aUj.zzcow(), this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo, this.aUj.isAnonymous());
            ((zzaha)this.aUl).zza(this.aUn, zzahf2);
            this.zzbf(null);
        }
    }

    static final class zzr
    extends zzagw<AuthResult, zzaha> {
        @NonNull
        private String aUa;

        public zzr(@NonNull String string) {
            super(2);
            this.aUa = zzac.zzh((String)string, (Object)"provider cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zze(this.aUa, this.aUj.zzcow(), this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo);
            ((zzaha)this.aUl).zza(this.aUn, zzahf2);
            this.zzbf(new zzahc(zzahf2));
        }
    }

    static final class zzq
    extends zzagw<AuthResult, zzaha> {
        public zzq() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zze(this.aUj.zzcow(), this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo);
            ((zzaha)this.aUl).zza(this.aUn, zzahf2);
            this.zzbf(new zzahc(zzahf2));
        }
    }

    static final class zzf
    extends zzagw<AuthResult, zzaha> {
        @NonNull
        private final VerifyAssertionRequest aTX;

        public zzf(@NonNull AuthCredential authCredential) {
            super(2);
            zzac.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aTX = zzahb.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zza(this.aUj.zzcow(), this.aTX, (zzagr)this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo);
            ((zzaha)this.aUl).zza(this.aUn, zzahf2);
            this.zzbf(new zzahc(zzahf2));
        }
    }

    static final class zze
    extends zzagw<AuthResult, zzaha> {
        @NonNull
        private final EmailAuthCredential aTW;

        public zze(@NonNull EmailAuthCredential emailAuthCredential) {
            super(2);
            this.aTW = (EmailAuthCredential)zzac.zzb((Object)emailAuthCredential, (Object)"credential cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zza(this.aTW.getEmail(), this.aTW.getPassword(), this.aUj.zzcow(), this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo);
            ((zzaha)this.aUl).zza(this.aUn, zzahf2);
            this.zzbf(new zzahc(zzahf2));
        }
    }

    static final class zzk
    extends zzagw<Void, zzaha> {
        @NonNull
        private String fG;

        public zzk(@NonNull String string) {
            super(6);
            this.fG = zzac.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zzh(this.fG, this.aUi);
        }

        @Override
        public void zzcpd() {
            this.zzcpk();
        }
    }

    static final class zzl
    extends zzagw<Void, zzaha> {
        @NonNull
        private String gU;

        public zzl(@NonNull String string) {
            super(4);
            this.gU = zzac.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zzd(this.gU, this.aUi);
        }

        @Override
        public void zzcpd() {
            this.zzcpk();
        }
    }

    static final class zzc
    extends zzagw<ProviderQueryResult, zzaha> {
        @NonNull
        private final String gU;

        public zzc(@NonNull String string) {
            super(3);
            this.gU = zzac.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zzc(this.gU, this.aUi);
        }

        @Override
        public void zzcpd() {
            this.zzbf(new zzahg(this.aUp));
        }
    }

    static final class zzi
    extends zzagw<Void, zzaha> {
        @NonNull
        private final String gU;
        @NonNull
        private final String gd;

        public zzi(@NonNull String string, @NonNull String string2) {
            super(2);
            this.gU = zzac.zzh((String)string, (Object)"email cannot be null or empty");
            this.gd = zzac.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zzd(this.gU, this.gd, this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo);
            if (this.aUj.getUid().equalsIgnoreCase(zzahf2.getUid())) {
                ((zzaha)this.aUl).zza(this.aUn, zzahf2);
                this.zzcpk();
            } else {
                this.zzex(zzahh.zzcqf());
            }
        }
    }

    static final class zzp
    extends zzagw<AuthResult, zzaha> {
        @NonNull
        private String gU;
        @NonNull
        private String gd;

        public zzp(String string, String string2) {
            super(2);
            this.gU = zzac.zzh((String)string, (Object)"email cannot be null or empty");
            this.gd = zzac.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zzd(this.gU, this.gd, this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo);
            ((zzaha)this.aUl).zza(this.aUn, zzahf2);
            this.zzbf(new zzahc(zzahf2));
        }
    }

    static final class zza
    extends zzagw<AuthResult, zzaha> {
        @NonNull
        private String gU;
        @NonNull
        private String gd;

        public zza(@NonNull String string, @NonNull String string2) {
            super(2);
            this.gU = zzac.zzh((String)string, (Object)"email cannot be null or empty");
            this.gd = zzac.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zzc(this.gU, this.gd, this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo);
            ((zzaha)this.aUl).zza(this.aUn, zzahf2);
            this.zzbf(new zzahc(zzahf2));
        }
    }

    static final class zzt
    extends zzagw<Void, zzaha> {
        @NonNull
        private final String gd;

        public zzt(@NonNull String string) {
            super(2);
            this.gd = zzac.zzh((String)string, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zzb(this.aUj.zzcow(), this.gd, this.aUi);
        }

        @Override
        public void zzcpd() {
            ((zzaha)this.aUl).zza(this.aUn, zzagl.zza(this.aTF, this.aUo));
            this.zzcpk();
        }
    }

    static final class zzs
    extends zzagw<Void, zzaha> {
        @NonNull
        private final String gU;

        public zzs(String string) {
            super(2);
            this.gU = zzac.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zza(this.aUj.zzcow(), this.gU, (zzagr)this.aUi);
        }

        @Override
        public void zzcpd() {
            ((zzaha)this.aUl).zza(this.aUn, zzagl.zza(this.aTF, this.aUo));
            this.zzcpk();
        }
    }

    static final class zzu
    extends zzagw<Void, zzaha> {
        @NonNull
        private final UserProfileChangeRequest aUb;

        public zzu(UserProfileChangeRequest userProfileChangeRequest) {
            super(2);
            this.aUb = (UserProfileChangeRequest)zzac.zzb((Object)userProfileChangeRequest, (Object)"request cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zza(this.aUj.zzcow(), this.aUb, (zzagr)this.aUi);
        }

        @Override
        public void zzcpd() {
            ((zzaha)this.aUl).zza(this.aUn, zzagl.zza(this.aTF, this.aUo));
            this.zzcpk();
        }
    }

    static final class zzm
    extends zzagw<AuthResult, zzaha> {
        public zzm() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zza(this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo, true);
            ((zzaha)this.aUl).zza(this.aUn, zzahf2);
            this.zzbf(new zzahc(zzahf2));
        }
    }

    static final class zzh
    extends zzagw<Void, zzaha> {
        @NonNull
        private final VerifyAssertionRequest aTX;

        public zzh(@NonNull AuthCredential authCredential) {
            super(2);
            zzac.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aTX = zzahb.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zza(this.aTX, (zzagr)this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo);
            if (this.aUj.getUid().equalsIgnoreCase(zzahf2.getUid())) {
                ((zzaha)this.aUl).zza(this.aUn, zzahf2);
                this.zzcpk();
            } else {
                this.zzex(zzahh.zzcqf());
            }
        }
    }

    static final class zzn
    extends zzagw<AuthResult, zzaha> {
        @NonNull
        private final VerifyAssertionRequest aTX;

        public zzn(@NonNull AuthCredential authCredential) {
            super(2);
            zzac.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aTX = zzahb.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zza(this.aTX, (zzagr)this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo);
            ((zzaha)this.aUl).zza(this.aUn, zzahf2);
            this.zzbf(new zzahc(zzahf2));
        }
    }

    static final class zzo
    extends zzagw<AuthResult, zzaha> {
        @NonNull
        private final String fG;

        public zzo(@NonNull String string) {
            super(2);
            this.fG = zzac.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zzb(this.fG, this.aUi);
        }

        @Override
        public void zzcpd() {
            zzahf zzahf2 = zzagl.zza(this.aTF, this.aUo);
            ((zzaha)this.aUl).zza(this.aUn, zzahf2);
            this.zzbf(new zzahc(zzahf2));
        }
    }

    static final class zzd
    extends zzagw<GetTokenResult, zzaha> {
        @NonNull
        private final String aTV;

        public zzd(@NonNull String string) {
            super(1);
            this.aTV = zzac.zzh((String)string, (Object)"refresh token cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aUk.zza(this.aTV, (zzagr)this.aUi);
        }

        @Override
        public void zzcpd() {
            this.aUn.zzrw(this.aTV);
            ((zzaha)this.aUl).zza(this.aUn, this.aUj);
            this.zzbf(new GetTokenResult(this.aUn.getAccessToken()));
        }
    }
}

