/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.maps.model.LatLngBounds;

public class SupportPlaceAutocompleteFragment
extends Fragment {
    private View akx;
    private View aky;
    private EditText akz;
    private boolean akA;
    @Nullable
    private LatLngBounds akB;
    @Nullable
    private AutocompleteFilter akC;
    @Nullable
    private PlaceSelectionListener akD;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.akx = view.findViewById(R.id.place_autocomplete_search_button);
        this.aky = view.findViewById(R.id.place_autocomplete_clear_button);
        this.akz = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (!SupportPlaceAutocompleteFragment.this.akA) {
                    SupportPlaceAutocompleteFragment.this.zzbrg();
                }
            }
        };
        this.akx.setOnClickListener(onClickListener);
        this.akz.setOnClickListener(onClickListener);
        this.aky.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SupportPlaceAutocompleteFragment.this.setText("");
            }
        });
        this.zzbrf();
        return view;
    }

    public void onDestroyView() {
        this.akx = null;
        this.aky = null;
        this.akz = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.akB = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.akC = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.akz.setText(charSequence);
        this.zzbrf();
    }

    public void setHint(CharSequence charSequence) {
        this.akz.setHint(charSequence);
        this.akx.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.akD = placeSelectionListener;
    }

    private void zzbrf() {
        boolean bl = !this.akz.getText().toString().isEmpty();
        this.aky.setVisibility(bl ? 0 : 8);
    }

    private void zzbrg() {
        GoogleApiAvailability googleApiAvailability;
        int n = -1;
        try {
            googleApiAvailability = new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.akB).setFilter(this.akC).zzlf(this.akz.getText().toString()).zzvp(1).build((Activity)this.getActivity());
            this.akA = true;
            this.startActivityForResult((Intent)googleApiAvailability, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException);
        }
        if (n != -1) {
            googleApiAvailability = GoogleApiAvailability.getInstance();
            googleApiAvailability.showErrorDialogFragment((Activity)this.getActivity(), n, 30422);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.akA = false;
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.akD != null) {
                    this.akD.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.akD != null) {
                    this.akD.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }
}

