/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzrh;
import com.google.android.gms.internal.zzri;
import com.google.android.gms.internal.zzro;
import com.google.android.gms.internal.zzrq;
import com.google.android.gms.internal.zzrr;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseException;
import java.util.Map;

public abstract class zzpy {
    public final int wf;
    public final int lN;

    public zzpy(int n, int n2) {
        this.wf = n;
        this.lN = n2;
    }

    public abstract void zzb(Api.zzb var1) throws DeadObjectException;

    public abstract void zzx(@NonNull Status var1);

    public boolean cancel() {
        return true;
    }

    public void zza(SparseArray<zzrq> sparseArray) {
    }

    public static final class zzd<TResult>
    extends zzpy {
        private final zzro<Api.zzb, TResult> wl;
        private final TaskCompletionSource<TResult> wh;
        private static final Status wm = new Status(8, "Connection to Google Play services was lost while executing the API call.");

        public zzd(int n, int n2, zzro<Api.zzb, TResult> zzro2, TaskCompletionSource<TResult> taskCompletionSource) {
            super(n, n2);
            this.wh = taskCompletionSource;
            this.wl = zzro2;
        }

        @Override
        public void zzb(Api.zzb zzb2) throws DeadObjectException {
            try {
                this.wl.zzb(zzb2, this.wh);
            }
            catch (DeadObjectException deadObjectException) {
                this.zzx(wm);
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.zzx(wm);
            }
        }

        @Override
        public void zzx(@NonNull Status status) {
            if (status.getStatusCode() == 8) {
                this.wh.setException((Exception)new FirebaseException(status.getStatusMessage()));
            } else {
                this.wh.setException((Exception)new FirebaseApiNotAvailableException(status.getStatusMessage()));
            }
        }
    }

    public static final class zze
    extends zza {
        public final zzrr<Api.zzb> wn;

        public zze(int n, zzrr<Api.zzb> zzrr2, TaskCompletionSource<Void> taskCompletionSource, SparseArray<Map<zzrd.zzb<?>, zzri>> sparseArray) {
            super(n, 4, taskCompletionSource, sparseArray);
            this.wn = zzrr2;
        }

        @Override
        public void zza(Api.zzb zzb2) throws DeadObjectException {
            Map map = (Map)this.wg.get(this.wf);
            if (map != null && this.wn.zzasr() != null) {
                map.remove(this.wn.zzasr());
                this.wn.zzc(zzb2, (TaskCompletionSource<Void>)this.wh);
            } else {
                Log.wtf((String)"UnregisterListenerTask", (String)"Received call to unregister a listener without a matching registration call.", (Throwable)new Exception());
                this.wh.setException((Exception)new com.google.android.gms.common.api.zza(Status.wa));
            }
        }
    }

    public static final class zzc
    extends zza {
        public final zzrh<Api.zzb> wj;
        public final zzrr<Api.zzb> wk;

        public zzc(int n, zzri zzri2, TaskCompletionSource<Void> taskCompletionSource, SparseArray<Map<zzrd.zzb<?>, zzri>> sparseArray) {
            super(n, 3, taskCompletionSource, sparseArray);
            this.wj = zzri2.wj;
            this.wk = zzri2.wk;
        }

        @Override
        public void zza(Api.zzb zzb2) throws DeadObjectException {
            this.wj.zza(zzb2, (TaskCompletionSource<Void>)this.wh);
            Map map = (Map)this.wg.get(this.wf);
            if (map == null) {
                map = new ArrayMap(1);
                this.wg.put(this.wf, (Object)map);
            }
            String string2 = String.valueOf(this.wj.zzasr());
            Log.d((String)"reg", (String)new StringBuilder(12 + String.valueOf(string2).length()).append("registered: ").append(string2).toString());
            if (this.wj.zzasr() != null) {
                map.put(this.wj.zzasr(), new zzri(this.wj, this.wk));
            }
        }
    }

    private static abstract class zza
    extends zzpy {
        protected final SparseArray<Map<zzrd.zzb<?>, zzri>> wg;
        protected final TaskCompletionSource<Void> wh;

        public zza(int n, int n2, TaskCompletionSource<Void> taskCompletionSource, SparseArray<Map<zzrd.zzb<?>, zzri>> sparseArray) {
            super(n, n2);
            this.wg = sparseArray;
            this.wh = taskCompletionSource;
        }

        @Override
        public void zzx(@NonNull Status status) {
            this.wh.setException((Exception)new com.google.android.gms.common.api.zza(status));
        }

        @Override
        public boolean cancel() {
            this.wh.setException((Exception)new com.google.android.gms.common.api.zza(Status.wc));
            return true;
        }

        @Override
        public void zza(SparseArray<zzrq> sparseArray) {
        }

        @Override
        public final void zzb(Api.zzb zzb2) throws DeadObjectException {
            try {
                this.zza(zzb2);
            }
            catch (DeadObjectException deadObjectException) {
                this.zza((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.zza(remoteException);
            }
        }

        protected abstract void zza(Api.zzb var1) throws RemoteException;

        private void zza(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.zzx(status);
        }
    }

    public static class zzb<A extends zzqc.zza<? extends Result, Api.zzb>>
    extends zzpy {
        protected final A wi;

        public zzb(int n, int n2, A a) {
            super(n, n2);
            this.wi = a;
        }

        @Override
        public void zzb(Api.zzb zzb2) throws DeadObjectException {
            ((zzqc.zza)this.wi).zzb((Api.zzb)zzb2);
        }

        @Override
        public void zzx(@NonNull Status status) {
            ((zzqc.zza)this.wi).zzz(status);
        }

        @Override
        public boolean cancel() {
            return ((zzqe)this.wi).zzaqq();
        }

        @Override
        public void zza(SparseArray<zzrq> sparseArray) {
            zzrq zzrq2 = (zzrq)sparseArray.get(this.wf);
            if (zzrq2 != null) {
                zzrq2.zzb((zzqe<? extends Result>)this.wi);
            }
        }
    }
}

