/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzamd;
import com.google.android.gms.internal.zzamf;
import com.google.android.gms.internal.zzamg;
import com.google.android.gms.internal.zzamh;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzamk;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class zzame {
    private static final AtomicInteger bgg = new AtomicInteger(0);
    private static final Charset bgh = Charset.forName("UTF-8");
    private volatile zza bgi = zza.bgu;
    private volatile Socket bgj = null;
    private zzamf bgk = null;
    private final URI bgl;
    private final zzamj bgm;
    private final zzamk bgn;
    private final zzamh bgo;
    private final int wr = bgg.incrementAndGet();
    private final Thread bgp = zzame.getThreadFactory().newThread(new Runnable(){

        @Override
        public void run() {
            zzame.this.l();
        }
    });
    private static ThreadFactory bgq = Executors.defaultThreadFactory();
    private static zzamd bgr = new zzamd(){

        @Override
        public void zza(Thread thread, String string) {
            thread.setName(string);
        }
    };

    static ThreadFactory getThreadFactory() {
        return bgq;
    }

    static zzamd f() {
        return bgr;
    }

    public static void zza(ThreadFactory threadFactory, zzamd zzamd2) {
        bgq = threadFactory;
        bgr = zzamd2;
    }

    public zzame(URI uRI, String string, Map<String, String> map) {
        this.bgl = uRI;
        this.bgo = new zzamh(uRI, string, map);
        this.bgm = new zzamj(this);
        this.bgn = new zzamk(this, "TubeSock", this.wr);
    }

    public void zza(zzamf zzamf2) {
        this.bgk = zzamf2;
    }

    zzamf g() {
        return this.bgk;
    }

    public synchronized void connect() {
        if (this.bgi != zza.bgu) {
            this.bgk.zza(new zzamg("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.wr;
        zzame.f().zza(this.m(), new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.bgi = zza.bgv;
        this.m().start();
    }

    public synchronized void zzsq(String string) {
        this.zza((byte)1, string.getBytes(bgh));
    }

    synchronized void zzav(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private synchronized void zza(byte by, byte[] byArray) {
        if (this.bgi != zza.bgw) {
            this.bgk.zza(new zzamg("error while sending data: not connected"));
        } else {
            try {
                this.bgn.zzb(by, true, byArray);
            }
            catch (IOException iOException) {
                this.bgk.zza(new zzamg("Failed to send frame", iOException));
                this.close();
            }
        }
    }

    void zzb(zzamg zzamg2) {
        this.bgk.zza(zzamg2);
        if (this.bgi == zza.bgw) {
            this.close();
        }
        this.i();
    }

    public synchronized void close() {
        switch (this.bgi) {
            case bgu: {
                this.bgi = zza.bgy;
                return;
            }
            case bgv: {
                this.i();
                return;
            }
            case bgw: {
                this.j();
                return;
            }
            case bgx: {
                return;
            }
            case bgy: {
                return;
            }
        }
    }

    void h() {
        this.i();
    }

    private synchronized void i() {
        if (this.bgi == zza.bgy) {
            return;
        }
        this.bgm.p();
        this.bgn.s();
        if (this.bgj != null) {
            try {
                this.bgj.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.bgi = zza.bgy;
        this.bgk.onClose();
    }

    private void j() {
        try {
            this.bgi = zza.bgx;
            this.bgn.s();
            this.bgn.zzb((byte)8, true, new byte[0]);
        }
        catch (IOException iOException) {
            this.bgk.zza(new zzamg("Failed to send close frame", iOException));
        }
    }

    private Socket createSocket() {
        Socket socket;
        String string = this.bgl.getScheme();
        String string2 = this.bgl.getHost();
        int n = this.bgl.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzamg(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.bgl);
                throw new zzamg(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SocketFactory socketFactory = SSLSocketFactory.getDefault();
                SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.bgl);
                    throw new zzamg(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzamg(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.bgl);
                throw new zzamg(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzamg(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public void k() throws InterruptedException {
        if (this.bgn.m().getState() != Thread.State.NEW) {
            this.bgn.m().join();
        }
        this.m().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void l() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.bgj = socket;
                if (this.bgi == zza.bgy) {
                    try {
                        this.bgj.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.bgj = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.bgo.n());
            boolean bl = false;
            int n = 1000;
            byte[] byArray = new byte[1000];
            int n2 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                Object object2;
                int n3 = ((FilterInputStream)object).read();
                if (n3 == -1) {
                    throw new zzamg("Connection closed before handshake was complete");
                }
                byArray[n2] = (byte)n3;
                if (byArray[++n2 - 1] == 10 && byArray[n2 - 2] == 13) {
                    object2 = new String(byArray, bgh);
                    if (((String)object2).trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(((String)object2).trim());
                    }
                    byArray = new byte[1000];
                    n2 = 0;
                    continue;
                }
                if (n2 != 1000) continue;
                object2 = new String(byArray, bgh);
                String string2 = String.valueOf(object2);
                if (string2.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string2);
                    throw new zzamg(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzamg(string);
            }
            this.bgo.zzta((String)arrayList.get(0));
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : arrayList) {
                String[] stringArray = string.split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            this.bgo.zzd(hashMap);
            this.bgn.zzb(outputStream);
            this.bgm.zza((DataInputStream)object);
            this.bgi = zza.bgw;
            this.bgn.m().start();
            this.bgk.zzctr();
            this.bgm.run();
            return;
        }
        catch (zzamg zzamg2) {
            this.bgk.zza(zzamg2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.bgk.zza(new zzamg(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    Thread m() {
        return this.bgp;
    }

    private static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza bgu = new zza();
        public static final /* enum */ zza bgv = new zza();
        public static final /* enum */ zza bgw = new zza();
        public static final /* enum */ zza bgx = new zza();
        public static final /* enum */ zza bgy = new zza();
        private static final /* synthetic */ zza[] bgz;

        public static zza[] values() {
            return (zza[])bgz.clone();
        }

        static {
            bgz = new zza[]{bgu, bgv, bgw, bgx, bgy};
        }
    }
}

