/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzn;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzo
extends zzn
implements Handler.Callback {
    private final HashMap<zza, zzb> CB = new HashMap();
    private final Context zzask;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zzb CC;
    private final long CD;

    zzo(Context context) {
        this.zzask = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.CC = com.google.android.gms.common.stats.zzb.zzawu();
        this.CD = 5000L;
    }

    @Override
    public boolean zza(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        return this.zza(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzac.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.CB;
        synchronized (hashMap) {
            zzb zzb2 = this.CB.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzhu(string2);
                this.CB.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    String string3 = String.valueOf(zza2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzhu(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        this.zzb(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzac.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.CB;
        synchronized (hashMap) {
            zzb zzb2 = this.CB.get(zza2);
            if (zzb2 == null) {
                String string3 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zzb2.zza(serviceConnection)) {
                String string4 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzauw()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.CD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                zzb zzb2 = (zzb)message.obj;
                HashMap<zza, zzb> hashMap = this.CB;
                synchronized (hashMap) {
                    if (zzb2.zzauw()) {
                        if (zzb2.isBound()) {
                            zzb2.zzhv("GmsClientSupervisor");
                        }
                        this.CB.remove(zzb2.CJ);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String V;
        private final String CE;
        private final ComponentName CF;

        public zza(String string2, String string3) {
            this.V = zzac.zzhz(string2);
            this.CE = zzac.zzhz(string3);
            this.CF = null;
        }

        public zza(ComponentName componentName) {
            this.V = null;
            this.CE = null;
            this.CF = zzac.zzy(componentName);
        }

        public String toString() {
            return this.V == null ? this.CF.flattenToString() : this.V;
        }

        public Intent zzauv() {
            Intent intent = this.V != null ? new Intent(this.V).setPackage(this.CE) : new Intent().setComponent(this.CF);
            return intent;
        }

        public int hashCode() {
            return zzab.hashCode(this.V, this.CF);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return zzab.equal(this.V, zza2.V) && zzab.equal(this.CF, zza2.CF);
        }
    }

    private final class zzb {
        private final zza CG;
        private final Set<ServiceConnection> CH;
        private int mState;
        private boolean CI;
        private IBinder Bz;
        private final com.google.android.gms.common.internal.zzo$zza CJ;
        private ComponentName CF;

        public zzb(com.google.android.gms.common.internal.zzo$zza zza2) {
            this.CJ = zza2;
            this.CG = new zza();
            this.CH = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        @TargetApi(value=14)
        public void zzhu(String string2) {
            this.mState = 3;
            this.CI = zzo.this.CC.zza(zzo.this.zzask, string2, this.CJ.zzauv(), this.CG, 129);
            if (!this.CI) {
                this.mState = 2;
                try {
                    zzo.this.CC.zza(zzo.this.zzask, this.CG);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void zzhv(String string2) {
            zzo.this.CC.zza(zzo.this.zzask, this.CG);
            this.CI = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzo.this.CC.zza(zzo.this.zzask, serviceConnection, string2, this.CJ.zzauv());
            this.CH.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzo.this.CC.zzb(zzo.this.zzask, serviceConnection);
            this.CH.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.CI;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.CH.contains(serviceConnection);
        }

        public boolean zzauw() {
            return this.CH.isEmpty();
        }

        public IBinder getBinder() {
            return this.Bz;
        }

        public ComponentName getComponentName() {
            return this.CF;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                HashMap hashMap = zzo.this.CB;
                synchronized (hashMap) {
                    zzb.this.Bz = iBinder;
                    zzb.this.CF = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.CH) {
                        serviceConnection.onServiceConnected(componentName, iBinder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName componentName) {
                HashMap hashMap = zzo.this.CB;
                synchronized (hashMap) {
                    zzb.this.Bz = null;
                    zzb.this.CF = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.CH) {
                        serviceConnection.onServiceDisconnected(componentName);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

