/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.internal.zzvg;
import com.google.android.gms.internal.zzvj;

public class zzvi {
    private static Boolean agy = null;
    private static ContentProviderClient agz;

    @TargetApi(value=11)
    private static Intent zza(Context context, String string, Parcelable parcelable, boolean bl) {
        Bundle bundle;
        if (context == null || string == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        if (!zzvi.zzdm(context)) {
            return null;
        }
        Bundle bundle2 = null;
        if (parcelable != null) {
            bundle2 = new Bundle(1);
            bundle2.putParcelable("key_fallbackIntent", parcelable);
        }
        try {
            bundle = zzvi.zza(context, "method_getInstantAppIntent", string, bundle2);
        }
        catch (DeadObjectException deadObjectException) {
            Log.e((String)"InstantAppsApi", (String)String.format("While calling %s %s:\n", zzvg.agx, "method_getInstantAppIntent"), (Throwable)deadObjectException);
            zzvi.reset();
            if (bl) {
                return zzvi.zza(context, string, parcelable, false);
            }
            return null;
        }
        catch (RemoteException | IllegalArgumentException throwable) {
            Log.e((String)"InstantAppsApi", (String)String.format("While calling %s %s:\n", zzvg.agx, "method_getInstantAppIntent"), (Throwable)throwable);
            return null;
        }
        if (bundle == null) {
            return null;
        }
        return (Intent)bundle.getParcelable("key_instantAppIntent");
    }

    @TargetApi(value=17)
    private static synchronized boolean zzdl(Context context) {
        if (agz == null) {
            agz = context.getContentResolver().acquireUnstableContentProviderClient(zzvg.agx);
        }
        return agz != null;
    }

    @TargetApi(value=17)
    private static synchronized Bundle zzd(String string, String string2, Bundle bundle) throws RemoteException {
        return agz.call(string, string2, bundle);
    }

    @TargetApi(value=11)
    private static synchronized Bundle zza(Context context, String string, String string2, Bundle bundle) throws RemoteException {
        if (agz == null) {
            return context.getContentResolver().call(zzvg.agx, string, string2, bundle);
        }
        return zzvi.zzd(string, string2, bundle);
    }

    static Intent getInstantAppIntent(Context context, String string, Intent intent) {
        return zzvi.zza(context, string, (Parcelable)intent, true);
    }

    @TargetApi(value=11)
    static synchronized boolean zzdm(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Parameter is null");
        }
        if (agy != null) {
            return agy;
        }
        agy = zzvi.zzdn(context);
        return agy;
    }

    private static synchronized boolean zzdn(Context context) {
        if (Build.VERSION.SDK_INT < 11) {
            return false;
        }
        if (!zzvj.zzdo(context)) {
            return false;
        }
        ProviderInfo providerInfo = context.getPackageManager().resolveContentProvider(zzvg.agx.getAuthority(), 0);
        if (providerInfo == null) {
            return false;
        }
        if (!providerInfo.packageName.equals("com.google.android.gms")) {
            String string = String.valueOf(providerInfo.packageName);
            Log.e((String)"InstantAppsApi", (String)(string.length() != 0 ? "Incorrect package name for instant apps content provider: ".concat(string) : new String("Incorrect package name for instant apps content provider: ")));
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || zzvi.zzdl(context);
    }

    static synchronized void reset() {
        if (agz != null) {
            agz.release();
            agz = null;
        }
        agy = null;
    }
}

