/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzanr;
import com.google.android.gms.internal.zzanv;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzd;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    private final StorageReference biD;
    private final Uri mUri;
    private final byte[] awi;
    private final byte[] bkd = new byte[262144];
    private final long bke;
    private final AtomicLong bkf = new AtomicLong(0L);
    private zzanm biF;
    private InputStream bkg;
    private volatile StorageMetadata bji;
    private volatile Uri bkh = null;
    private volatile Exception aJM = null;
    private volatile Exception bki = null;
    private volatile int mResultCode = 0;
    private volatile String bkj;

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, byte[] byArray) {
        zzac.zzy((Object)storageReference);
        zzac.zzy((Object)byArray);
        this.awi = byArray;
        this.bke = this.awi.length;
        this.biD = storageReference;
        this.bji = storageMetadata;
        this.mUri = null;
        this.bkg = new BufferedInputStream(new ByteArrayInputStream(this.awi), 262144);
        this.biF = new zzanm(this.biD.getApp(), this.biD.getStorage().getMaxUploadRetryTimeMillis());
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, Uri uri, Uri uri2) {
        zzac.zzy((Object)storageReference);
        zzac.zzy((Object)uri);
        this.awi = null;
        this.biD = storageReference;
        this.bji = storageMetadata;
        this.mUri = uri;
        InputStream inputStream = null;
        this.biF = new zzanm(this.biD.getApp(), this.biD.getStorage().getMaxUploadRetryTimeMillis());
        long l = -1L;
        try {
            ContentResolver contentResolver = this.biD.getStorage().getApp().getApplicationContext().getContentResolver();
            try {
                ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(this.mUri, "r");
                if (parcelFileDescriptor != null) {
                    l = parcelFileDescriptor.getStatSize();
                    parcelFileDescriptor.close();
                }
            }
            catch (NullPointerException nullPointerException) {
                Log.w((String)"UploadTask", (String)"NullPointerException during file size calculation.", (Throwable)nullPointerException);
                l = -1L;
            }
            catch (IOException iOException) {
                String string = String.valueOf(this.mUri.toString());
                Log.w((String)"UploadTask", (String)(string.length() != 0 ? "could not retrieve file size for upload ".concat(string) : new String("could not retrieve file size for upload ")));
            }
            inputStream = contentResolver.openInputStream(this.mUri);
            if (inputStream != null) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = String.valueOf(this.mUri.toString());
            Log.e((String)"UploadTask", (String)(string.length() != 0 ? "could not locate file for uploading:".concat(string) : new String("could not locate file for uploading:")));
            this.aJM = fileNotFoundException;
        }
        this.bke = l;
        this.bkg = inputStream;
        this.bkh = uri2;
    }

    UploadTask(StorageReference storageReference, StorageMetadata storageMetadata, InputStream inputStream) {
        zzac.zzy((Object)storageReference);
        zzac.zzy((Object)inputStream);
        this.bke = -1L;
        this.awi = null;
        this.biD = storageReference;
        this.bji = storageMetadata;
        this.bkg = new BufferedInputStream(inputStream, 262144);
        this.mUri = null;
        this.biF = new zzanm(this.biD.getApp(), this.biD.getStorage().getMaxUploadRetryTimeMillis());
    }

    @Override
    StorageReference getStorage() {
        return this.biD;
    }

    long getTotalByteCount() {
        return this.bke;
    }

    @Override
    protected void schedule() {
        zzd.at().zzu(this.zzcnk());
    }

    @Override
    void run() {
        this.biF.reset();
        if (this.biD.getParent() == null) {
            this.aJM = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
        }
        if (this.aJM != null) {
            this.zzi(64, false);
            return;
        }
        if (this.bkh == null) {
            this.ax();
        } else {
            this.zzdc(false);
        }
        while (this.ay()) {
            this.zzi(4, false);
            this.aA();
        }
    }

    @Override
    protected void resetState() {
        this.aJM = null;
        this.bki = null;
        this.mResultCode = 0;
        this.bkj = null;
    }

    private void ax() {
        Object object;
        String string = null;
        if (this.bji != null) {
            string = this.bji.getContentType();
        }
        if (this.mUri != null && TextUtils.isEmpty((CharSequence)string)) {
            object = this.biD.getStorage().getApp().getApplicationContext();
            string = object.getContentResolver().getType(this.mUri);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "application/octet-stream";
        }
        try {
            object = this.biD.al().zza(this.biD.am(), this.bji != null ? this.bji.ak() : null, string);
        }
        catch (RemoteException | JSONException throwable) {
            Log.e((String)"UploadTask", (String)"Unable to create a network request from metadata", (Throwable)throwable);
            this.aJM = throwable;
            return;
        }
        if (!this.zzb((zzanv)object)) {
            return;
        }
        String string2 = ((zzanv)object).zzul("X-Goog-Upload-URL");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.bkh = Uri.parse((String)string2);
        }
    }

    private boolean ay() {
        boolean bl;
        if (this.ao() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.aJM = new InterruptedException();
            this.zzi(64, false);
            return false;
        }
        if (this.ao() == 32) {
            this.zzi(256, false);
            return false;
        }
        if (this.ao() == 8) {
            this.zzi(16, false);
            return false;
        }
        if (!this.az()) {
            return false;
        }
        if (this.bkh == null) {
            if (this.aJM == null) {
                this.aJM = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.zzi(64, false);
            return false;
        }
        if (this.aJM != null) {
            this.zzi(64, false);
            return false;
        }
        boolean bl2 = bl = this.bki != null || this.mResultCode < 200 || this.mResultCode >= 300;
        if (bl && !this.zzdc(true)) {
            if (this.az()) {
                this.zzi(64, false);
            }
            return false;
        }
        return true;
    }

    private boolean az() {
        if ("final".equals(this.bkj)) {
            if (this.aJM == null) {
                this.aJM = new IOException("The server has terminated the upload session");
            }
            this.zzi(64, false);
            return false;
        }
        return true;
    }

    private boolean zzdc(boolean bl) {
        zzanv zzanv2;
        try {
            zzanv2 = this.biD.al().zzb(this.biD.am(), this.bkh.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to recover status during resumable upload", (Throwable)remoteException);
            this.aJM = remoteException;
            return false;
        }
        if ("final".equals(this.bkj)) {
            return false;
        }
        if (bl ? !this.zzb(zzanv2) : !this.zza(zzanv2)) {
            return false;
        }
        if ("final".equals(zzanv2.zzul("X-Goog-Upload-Status"))) {
            this.aJM = new IOException("The server has terminated the upload session");
            return false;
        }
        String string = zzanv2.zzul("X-Goog-Upload-Size-Received");
        long l = !TextUtils.isEmpty((CharSequence)string) ? Long.parseLong(string) : 0L;
        long l2 = this.bkf.get();
        if (l2 > l) {
            this.aJM = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (l2 < l) {
            try {
                if (this.bkg.skip(l - l2) != l - l2) {
                    this.aJM = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.bkf.compareAndSet(l2, l)) {
                    Log.e((String)"UploadTask", (String)"Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.aJM = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException iOException) {
                Log.e((String)"UploadTask", (String)"Unable to recover position in Stream during resumable upload", (Throwable)iOException);
                this.aJM = iOException;
                return false;
            }
        }
        return true;
    }

    private void aA() {
        zzanv zzanv2;
        int n;
        this.bkg.mark(this.bkd.length + 1);
        try {
            n = this.bkg.read(this.bkd);
        }
        catch (IOException iOException) {
            Log.e((String)"UploadTask", (String)"Unable to read bytes for uploading", (Throwable)iOException);
            this.aJM = iOException;
            return;
        }
        try {
            zzanv2 = this.biD.al().zza(this.biD.am(), this.bkh.toString(), this.bkd, this.bkf.get(), n, (long)n != 262144L);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
            this.aJM = remoteException;
            return;
        }
        if (!this.zza(zzanv2)) {
            try {
                this.bkg.reset();
            }
            catch (IOException iOException) {
                Log.w((String)"UploadTask", (String)"Unable to reset the stream for error recovery.", (Throwable)iOException);
                this.aJM = iOException;
            }
            return;
        }
        if (n != -1) {
            this.bkf.getAndAdd(n);
        }
        if ((long)n != 262144L) {
            try {
                this.bji = new StorageMetadata.Builder(zzanv2.aN(), this.biD).build();
            }
            catch (RemoteException | JSONException throwable) {
                String string = String.valueOf(zzanv2.aH());
                Log.e((String)"UploadTask", (String)(string.length() != 0 ? "Unable to parse resulting metadata from upload:".concat(string) : new String("Unable to parse resulting metadata from upload:")), (Throwable)throwable);
                this.aJM = throwable;
                return;
            }
            this.zzi(4, false);
            this.zzi(128, false);
        }
    }

    private boolean zzagp(int n) {
        return n == 308 || n >= 200 && n < 300;
    }

    private boolean zza(zzanv zzanv2) {
        zzanv2.zza(zzanr.zzi(this.biD.getApp()), this.biD.getApp().getApplicationContext());
        return this.zzc(zzanv2);
    }

    private boolean zzb(zzanv zzanv2) {
        this.biF.zzd(zzanv2);
        return this.zzc(zzanv2);
    }

    private boolean zzc(zzanv zzanv2) {
        int n = zzanv2.getResultCode();
        this.mResultCode = this.biF.zzagt(n) ? -2 : n;
        this.bki = zzanv2.getException();
        this.bkj = zzanv2.zzul("X-Goog-Upload-Status");
        return this.zzagp(this.mResultCode) && this.bki == null;
    }

    @Override
    protected void onCanceled() {
        this.biF.cancel();
        zzanv zzanv2 = null;
        try {
            zzanv2 = this.biD.al().zza(this.biD.am(), this.bkh.toString());
        }
        catch (RemoteException remoteException) {
            Log.e((String)"UploadTask", (String)"Unable to create chunk upload request", (Throwable)remoteException);
        }
        if (zzanv2 != null) {
            final zzanv zzanv3 = zzanv2;
            zzd.at().zzt(new Runnable(){

                @Override
                public void run() {
                    zzanv3.zza(zzanr.zzi(UploadTask.this.biD.getApp()), UploadTask.this.biD.getApp().getApplicationContext());
                }
            });
        }
        this.aJM = StorageException.fromErrorStatus(Status.wc);
        super.onCanceled();
    }

    @NonNull
    TaskSnapshot aB() {
        Exception exception = this.aJM != null ? this.aJM : this.bki;
        return new TaskSnapshot((Exception)((Object)StorageException.fromExceptionAndHttpCode(exception, this.mResultCode)), this.bkf.get(), this.bkh, this.bji);
    }

    @Override
    @NonNull
    /* synthetic */ StorageTask.ProvideError ai() {
        return this.aB();
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long bkm;
        private final Uri bkh;
        private final StorageMetadata bji;

        TaskSnapshot(Exception exception, long l, Uri uri, StorageMetadata storageMetadata) {
            super(exception);
            this.bkm = l;
            this.bkh = uri;
            this.bji = storageMetadata;
        }

        public long getBytesTransferred() {
            return this.bkm;
        }

        public long getTotalByteCount() {
            return UploadTask.this.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.bkh;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.bji;
        }

        @Nullable
        public Uri getDownloadUrl() {
            StorageMetadata storageMetadata = this.getMetadata();
            if (storageMetadata != null) {
                return storageMetadata.getDownloadUrl();
            }
            return null;
        }
    }
}

