/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzans;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageException;
import java.io.InputStream;
import java.net.SocketException;
import org.json.JSONObject;

public class zzanv {
    private zzans bkw;
    private Exception aJM;
    private int bkx;
    private Exception bky;

    public zzanv(@NonNull zzans zzans2) {
        this.bkw = zzans2;
    }

    private boolean zzfb(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.bkx = -2;
            this.bky = new SocketException("Network subsystem is unavailable");
            return false;
        }
        return true;
    }

    @Nullable
    public String zzul(String string) {
        try {
            return this.bkw.zzul(string);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(string);
            Log.e((String)"NetworkRequestProxy", (String)(string2.length() != 0 ? "getResultString failed with a RemoteException:".concat(string2) : new String("getResultString failed with a RemoteException:")), (Throwable)remoteException);
            return null;
        }
    }

    public void zza(@Nullable String string, @NonNull Context context) {
        try {
            if (!this.zzfb(context)) {
                return;
            }
            this.bkw.zzuj(string);
        }
        catch (RemoteException remoteException) {
            this.aJM = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequest failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void reset() {
        try {
            this.bkx = 0;
            this.bky = null;
            this.bkw.reset();
        }
        catch (RemoteException remoteException) {
            this.aJM = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"reset failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void zzuk(@Nullable String string) {
        try {
            this.bkw.zzuk(string);
        }
        catch (RemoteException remoteException) {
            this.aJM = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestStart failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    public void aE() {
        try {
            this.bkw.aE();
        }
        catch (RemoteException remoteException) {
            this.aJM = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"performRequestEnd failed with a RemoteException:", (Throwable)remoteException);
        }
    }

    @Nullable
    public InputStream getStream() {
        try {
            return (InputStream)zze.zzae((zzd)this.bkw.aF());
        }
        catch (RemoteException remoteException) {
            this.aJM = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getStream failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @NonNull
    public JSONObject aN() throws RemoteException {
        return (JSONObject)zze.zzae((zzd)this.bkw.aG());
    }

    @Nullable
    public String aH() {
        try {
            this.bkw.aH();
        }
        catch (RemoteException remoteException) {
            this.aJM = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getRawResult failed with a RemoteException:", (Throwable)remoteException);
        }
        return null;
    }

    @Nullable
    public Exception getException() {
        try {
            if (this.bky != null) {
                return this.bky;
            }
            return this.aJM != null ? this.aJM : (Exception)zze.zzae((zzd)this.bkw.aJ());
        }
        catch (RemoteException remoteException) {
            this.aJM = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getException failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    public int getResultCode() {
        try {
            if (this.bkx != 0) {
                return this.bkx;
            }
            return this.bkw.getResultCode();
        }
        catch (RemoteException remoteException) {
            this.aJM = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultCode failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }

    public boolean aK() {
        try {
            if (this.bkx == -2 || this.bky != null) {
                return false;
            }
            return this.bkw.aK();
        }
        catch (RemoteException remoteException) {
            this.aJM = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"isResultSuccess failed with a RemoteException:", (Throwable)remoteException);
            return false;
        }
    }

    public <TResult> void zza(TaskCompletionSource<TResult> taskCompletionSource, TResult TResult) {
        Exception exception = this.getException();
        if (this.aK() && exception == null) {
            taskCompletionSource.setResult(TResult);
        } else {
            StorageException storageException = StorageException.fromExceptionAndHttpCode(exception, this.getResultCode());
            assert (storageException != null);
            taskCompletionSource.setException((Exception)((Object)storageException));
        }
    }

    public int aL() {
        try {
            return this.bkw.aL();
        }
        catch (RemoteException remoteException) {
            this.aJM = remoteException;
            Log.e((String)"NetworkRequestProxy", (String)"getResultingContentLength failed with a RemoteException:", (Throwable)remoteException);
            return 0;
        }
    }
}

