/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.gcm.GcmListenerService;
import java.util.Iterator;
import java.util.List;
import java.util.MissingFormatArgumentException;
import org.json.JSONArray;
import org.json.JSONException;

class zza {
    static zza aeG;
    private final Context mContext;

    static synchronized zza zzdc(Context context) {
        if (aeG == null) {
            aeG = new zza(context);
        }
        return aeG;
    }

    static boolean zzad(Bundle bundle) {
        return "1".equals(zza.zzf(bundle, "gcm.n.e")) || zza.zzf(bundle, "gcm.n.icon") != null;
    }

    static boolean zzdd(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        if (keyguardManager.inKeyguardRestrictedInputMode()) {
            return false;
        }
        int n = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.importance == 100;
            }
        }
        return false;
    }

    static void zzae(Bundle bundle) {
        String string;
        Bundle bundle2 = new Bundle();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            String string2 = bundle.getString(string);
            if (string.startsWith("gcm.notification.")) {
                string = string.replace("gcm.notification.", "gcm.n.");
            }
            if (!string.startsWith("gcm.n.")) continue;
            if (!"gcm.n.e".equals(string)) {
                bundle2.putString(string.substring("gcm.n.".length()), string2);
            }
            iterator.remove();
        }
        string = bundle2.getString("sound2");
        if (string != null) {
            bundle2.remove("sound2");
            bundle2.putString("sound", string);
        }
        if (!bundle2.isEmpty()) {
            bundle.putBundle("notification", bundle2);
        }
    }

    static String zzf(Bundle bundle, String string) {
        String string2 = bundle.getString(string);
        if (string2 == null) {
            string2 = bundle.getString(string.replace("gcm.n.", "gcm.notification."));
        }
        return string2;
    }

    private zza(Context context) {
        this.mContext = context.getApplicationContext();
    }

    boolean zzaf(Bundle bundle) {
        try {
            Notification notification = this.zzag(bundle);
            this.zza(zza.zzf(bundle, "gcm.n.tag"), notification);
            return true;
        }
        catch (zza zza2) {
            String string = String.valueOf(zza2.getMessage());
            Log.e((String)"GcmNotification", (String)(string.length() != 0 ? "Failed to show notification: ".concat(string) : new String("Failed to show notification: ")));
            return false;
        }
    }

    private Notification zzag(Bundle bundle) {
        NotificationCompat.Builder builder;
        block5: {
            String string = this.zzg(bundle, "gcm.n.title");
            String string2 = this.zzg(bundle, "gcm.n.body");
            int n = this.zzkl(zza.zzf(bundle, "gcm.n.icon"));
            String string3 = zza.zzf(bundle, "gcm.n.color");
            Uri uri = this.zzkm(zza.zzf(bundle, "gcm.n.sound2"));
            PendingIntent pendingIntent = this.zzah(bundle);
            Object var8_8 = null;
            builder = new NotificationCompat.Builder(this.mContext).setAutoCancel(true).setSmallIcon(n);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                builder.setContentTitle((CharSequence)string);
            } else {
                builder.setContentTitle(this.mContext.getApplicationInfo().loadLabel(this.mContext.getPackageManager()));
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                builder.setContentText((CharSequence)string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                builder.setColor(Color.parseColor((String)string3));
            }
            if (uri != null) {
                builder.setSound(uri);
            }
            if (pendingIntent == null) break block5;
            builder.setContentIntent(pendingIntent);
        }
        return builder.build();
    }

    private void zza(String string, Notification notification) {
        if (Log.isLoggable((String)"GcmNotification", (int)3)) {
            Log.d((String)"GcmNotification", (String)"Showing notification");
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)string)) {
            long l = SystemClock.uptimeMillis();
            string = new StringBuilder(37).append("GCM-Notification:").append(l).toString();
        }
        notificationManager.notify(string, 0, notification);
    }

    private String zzg(Bundle bundle, String string) {
        String string2 = zza.zzf(bundle, string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        String string3 = String.valueOf(string);
        String string4 = String.valueOf("_loc_key");
        String string5 = zza.zzf(bundle, string4.length() != 0 ? string3.concat(string4) : new String(string3));
        if (TextUtils.isEmpty((CharSequence)string5)) {
            return null;
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string5, "string", this.mContext.getPackageName());
        if (n == 0) {
            String string6 = String.valueOf(string);
            String string7 = String.valueOf("_loc_key");
            String string8 = String.valueOf(this.zzkk(string7.length() != 0 ? string6.concat(string7) : new String(string6)));
            Log.w((String)"GcmNotification", (String)new StringBuilder(49 + String.valueOf(string8).length() + String.valueOf(string5).length()).append(string8).append(" resource not found: ").append(string5).append(" Default value will be used.").toString());
            return null;
        }
        String string9 = String.valueOf(string);
        String string10 = String.valueOf("_loc_args");
        String string11 = zza.zzf(bundle, string10.length() != 0 ? string9.concat(string10) : new String(string9));
        if (TextUtils.isEmpty((CharSequence)string11)) {
            return resources.getString(n);
        }
        try {
            JSONArray jSONArray = new JSONArray(string11);
            Object[] objectArray = new String[jSONArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = jSONArray.opt(i);
            }
            return resources.getString(n, objectArray);
        }
        catch (JSONException jSONException) {
            String string12 = String.valueOf(string);
            String string13 = String.valueOf("_loc_args");
            String string14 = String.valueOf(this.zzkk(string13.length() != 0 ? string12.concat(string13) : new String(string12)));
            Log.w((String)"GcmNotification", (String)new StringBuilder(41 + String.valueOf(string14).length() + String.valueOf(string11).length()).append("Malformed ").append(string14).append(": ").append(string11).append("  Default value will be used.").toString());
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            Log.w((String)"GcmNotification", (String)new StringBuilder(58 + String.valueOf(string5).length() + String.valueOf(string11).length()).append("Missing format argument for ").append(string5).append(": ").append(string11).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
        }
        return null;
    }

    private String zzkk(String string) {
        return string.substring("gcm.n.".length());
    }

    private int zzkl(String string) {
        int n;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Resources resources = this.mContext.getResources();
            int n2 = resources.getIdentifier(string, "drawable", this.mContext.getPackageName());
            if (n2 != 0) {
                return n2;
            }
            n2 = resources.getIdentifier(string, "mipmap", this.mContext.getPackageName());
            if (n2 != 0) {
                return n2;
            }
            Log.w((String)"GcmNotification", (String)new StringBuilder(57 + String.valueOf(string).length()).append("Icon resource ").append(string).append(" not found. Notification will use app icon.").toString());
        }
        if ((n = this.mContext.getApplicationInfo().icon) == 0) {
            n = 17301651;
        }
        return n;
    }

    private Uri zzkm(String string) {
        Resources resources;
        int n;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (!"default".equals(string) && (n = (resources = this.mContext.getResources()).getIdentifier(string, "raw", this.mContext.getPackageName())) != 0) {
            String string2 = String.valueOf("android.resource://");
            String string3 = String.valueOf(this.mContext.getPackageName());
            return Uri.parse((String)new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string).length()).append(string2).append(string3).append("/raw/").append(string).toString());
        }
        return RingtoneManager.getDefaultUri((int)2);
    }

    private PendingIntent zzah(Bundle bundle) {
        Intent intent;
        String string = zza.zzf(bundle, "gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            intent = new Intent(string);
            intent.setPackage(this.mContext.getPackageName());
            intent.setFlags(0x10000000);
        } else {
            PackageManager packageManager = this.mContext.getPackageManager();
            intent = packageManager.getLaunchIntentForPackage(this.mContext.getPackageName());
            if (intent == null) {
                Log.w((String)"GcmNotification", (String)"No activity found to launch app");
                return null;
            }
        }
        bundle = new Bundle(bundle);
        GcmListenerService.zzac(bundle);
        intent.putExtras(bundle);
        for (String string2 : bundle.keySet()) {
            if (!string2.startsWith("gcm.n.") && !string2.startsWith("gcm.notification.")) continue;
            intent.removeExtra(string2);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzbnz(), (Intent)intent, (int)0x40000000);
    }

    private int zzbnz() {
        return (int)SystemClock.uptimeMillis();
    }

    private class zza
    extends IllegalArgumentException {
    }
}

