/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzc;

public abstract class Task
implements Parcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String afk;
    private final String mTag;
    private final boolean afl;
    private final boolean afm;
    private final int afn;
    private final boolean afo;
    private final zzc afp;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.afk = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.afl = builder.updateCurrent;
        this.afm = builder.isPersisted;
        this.afn = builder.requiredNetworkState;
        this.afo = builder.requiresCharging;
        this.mExtras = builder.extras;
        this.afp = builder.afq != null ? builder.afq : zzc.aff;
    }

    @Deprecated
    Task(Parcel parcel) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.afk = parcel.readString();
        this.mTag = parcel.readString();
        this.afl = parcel.readInt() == 1;
        this.afm = parcel.readInt() == 1;
        this.afn = 2;
        this.afo = false;
        this.afp = zzc.aff;
        this.mExtras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.afl);
        bundle.putBoolean("persisted", this.afm);
        bundle.putString("service", this.afk);
        bundle.putInt("requiredNetwork", this.afn);
        bundle.putBoolean("requiresCharging", this.afo);
        bundle.putBundle("retryStrategy", this.afp.zzaj(new Bundle()));
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.afk;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.afl;
    }

    public boolean isPersisted() {
        return this.afm;
    }

    public int getRequiredNetwork() {
        return this.afn;
    }

    public boolean getRequiresCharging() {
        return this.afo;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.afk);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.afl ? 1 : 0);
        parcel.writeInt(this.afm ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zza(zzc zzc2) {
        if (zzc2 != null) {
            int n = zzc2.zzboc();
            if (n != 1 && n != 0) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Must provide a valid RetryPolicy: ").append(n).toString());
            }
            int n2 = zzc2.zzbod();
            int n3 = zzc2.zzboe();
            if (n == 0 && n2 < 0) {
                throw new IllegalArgumentException(new StringBuilder(52).append("InitialBackoffSeconds can't be negative: ").append(n2).toString());
            }
            if (n == 1 && n2 < 10) {
                throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
            }
            if (n3 < n2) {
                int n4 = zzc2.zzboe();
                throw new IllegalArgumentException(new StringBuilder(77).append("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: ").append(n4).toString());
            }
        }
    }

    public static void zzak(Bundle bundle) {
        if (bundle != null) {
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            if (n > 10240) {
                parcel.recycle();
                String string = String.valueOf("Extras exceeding maximum size(10240 bytes): ");
                throw new IllegalArgumentException(new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
            }
            parcel.recycle();
            for (String string : bundle.keySet()) {
                if (Task.zzah(bundle.get(string))) continue;
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, and Boolean. ");
            }
        }
    }

    private static boolean zzah(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean;
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected zzc afq = zzc.aff;
        protected Bundle extras;

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        @CallSuper
        protected void checkConditions() {
            zzac.zzb((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzki(this.tag);
            Task.zza(this.afq);
            if (this.isPersisted) {
                Task.zzak(this.extras);
            }
        }
    }
}

