/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class OneoffTask
extends Task {
    private final long aeZ;
    private final long afa;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new Parcelable.Creator<OneoffTask>(){

        public OneoffTask zzmw(Parcel parcel) {
            return new OneoffTask(parcel);
        }

        public OneoffTask[] zztn(int n) {
            return new OneoffTask[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.zztn(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzmw(parcel);
        }
    };

    private OneoffTask(Builder builder) {
        super(builder);
        this.aeZ = builder.afb;
        this.afa = builder.afc;
    }

    @Deprecated
    private OneoffTask(Parcel parcel) {
        super(parcel);
        this.aeZ = parcel.readLong();
        this.afa = parcel.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.aeZ);
        bundle.putLong("window_end", this.afa);
    }

    public long getWindowStart() {
        return this.aeZ;
    }

    public long getWindowEnd() {
        return this.afa;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.aeZ);
        parcel.writeLong(this.afa);
    }

    public String toString() {
        String string = String.valueOf(super.toString());
        long l = this.getWindowStart();
        long l2 = this.getWindowEnd();
        return new StringBuilder(64 + String.valueOf(string).length()).append(string).append(" windowStart=").append(l).append(" windowEnd=").append(l2).toString();
    }

    public static class Builder
    extends Task.Builder {
        private long afb = -1L;
        private long afc = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long l, long l2) {
            this.afb = l;
            this.afc = l2;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string) {
            this.tag = string;
            return this;
        }

        @Override
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.afb == -1L || this.afc == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.afb >= this.afc) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            this.checkConditions();
            return new OneoffTask(this);
        }
    }
}

