/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.gcm.PendingCallback;
import com.google.android.gms.gcm.TaskParams;
import com.google.android.gms.gcm.zzb;
import java.util.HashSet;
import java.util.Set;

public abstract class GcmTaskService
extends Service {
    public static final String SERVICE_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    public static final String SERVICE_ACTION_EXECUTE_TASK = "com.google.android.gms.gcm.ACTION_TASK_READY";
    public static final String SERVICE_ACTION_INITIALIZE = "com.google.android.gms.gcm.SERVICE_ACTION_INITIALIZE";
    private final Set<String> aeL = new HashSet<String>();
    private int aeM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    public int onStartCommand(Intent intent, int n, int n2) {
        try {
            if (intent == null) {
                int n3 = 2;
                return 2;
            }
            intent.setExtrasClassLoader(PendingCallback.class.getClassLoader());
            String string = intent.getAction();
            if (SERVICE_ACTION_EXECUTE_TASK.equals(string)) {
                String string2 = intent.getStringExtra("tag");
                Parcelable parcelable = intent.getParcelableExtra("callback");
                Bundle bundle = (Bundle)intent.getParcelableExtra("extras");
                if (parcelable == null || !(parcelable instanceof PendingCallback)) {
                    String string3 = String.valueOf(this.getPackageName());
                    Log.e((String)"GcmTaskService", (String)new StringBuilder(47 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).append(": Could not process request, invalid callback.").toString());
                    int n4 = 2;
                    return 2;
                }
                Set<String> set = this.aeL;
                synchronized (set) {
                    this.aeL.add(string2);
                }
                new zza(string2, ((PendingCallback)parcelable).getIBinder(), bundle).start();
            } else if (SERVICE_ACTION_INITIALIZE.equals(string)) {
                this.onInitializeTasks();
            } else {
                Log.e((String)"GcmTaskService", (String)new StringBuilder(37 + String.valueOf(string).length()).append("Unknown action received ").append(string).append(", terminating").toString());
            }
            int n5 = 2;
            return 2;
        }
        finally {
            this.zztl(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zztl(int n) {
        Set<String> set = this.aeL;
        synchronized (set) {
            this.aeM = n;
            if (this.aeL.size() == 0) {
                this.stopSelf(this.aeM);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzkn(String string) {
        Set<String> set = this.aeL;
        synchronized (set) {
            this.aeL.remove(string);
            if (this.aeL.size() == 0) {
                this.stopSelf(this.aeM);
            }
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public abstract int onRunTask(TaskParams var1);

    public void onInitializeTasks() {
    }

    private class zza
    extends Thread {
        private final String mTag;
        private final zzb aeN;
        private final Bundle mExtras;

        zza(String string, IBinder iBinder, Bundle bundle) {
            super(String.valueOf(string).concat(" GCM Task"));
            this.mTag = string;
            this.aeN = zzb.zza.zzgs(iBinder);
            this.mExtras = bundle;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            int n = GcmTaskService.this.onRunTask(new TaskParams(this.mTag, this.mExtras));
            try {
                this.aeN.zztm(n);
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf(this.mTag);
                Log.e((String)"GcmTaskService", (String)(string.length() != 0 ? "Error reporting result of operation to scheduler for ".concat(string) : new String("Error reporting result of operation to scheduler for ")));
            }
            finally {
                GcmTaskService.this.zzkn(this.mTag);
            }
        }
    }
}

