/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Base64;
import android.util.Log;

public class GcmReceiver
extends WakefulBroadcastReceiver {
    private static String aeK = "gcm.googleapis.com/refresh";

    public void onReceive(Context context, Intent intent) {
        String string;
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        String string2 = intent.getStringExtra("from");
        if ("com.google.android.c2dm.intent.REGISTRATION".equals(intent.getAction()) || "google.com/iid".equals(string2) || aeK.equals(string2)) {
            intent.setAction("com.google.android.gms.iid.InstanceID");
        }
        if ((string = intent.getStringExtra("gcm.rawData64")) != null) {
            intent.putExtra("rawData", Base64.decode((String)string, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        if ("com.google.android.c2dm.intent.RECEIVE".equals(intent.getAction())) {
            this.zze(context, intent);
        } else {
            this.doStartService(context, intent);
        }
        if (this.isOrderedBroadcast() && this.getResultCode() == 0) {
            this.setResultCode(-1);
        }
    }

    public void zze(Context context, Intent intent) {
        this.doStartService(context, intent);
    }

    private void doStartService(Context context, Intent intent) {
        block9: {
            if (this.isOrderedBroadcast()) {
                this.setResultCode(500);
            }
            this.zzf(context, intent);
            try {
                ComponentName componentName;
                if (context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0) {
                    componentName = GcmReceiver.startWakefulService((Context)context, (Intent)intent);
                } else {
                    componentName = context.startService(intent);
                    Log.d((String)"GcmReceiver", (String)"Missing wake lock permission, service start may be delayed");
                }
                if (componentName == null) {
                    Log.e((String)"GcmReceiver", (String)"Error while delivering the message: ServiceIntent not found.");
                    if (this.isOrderedBroadcast()) {
                        this.setResultCode(404);
                    }
                } else if (this.isOrderedBroadcast()) {
                    this.setResultCode(-1);
                }
            }
            catch (SecurityException securityException) {
                Log.e((String)"GcmReceiver", (String)"Error while delivering the message to the serviceIntent", (Throwable)securityException);
                if (!this.isOrderedBroadcast()) break block9;
                this.setResultCode(401);
            }
        }
    }

    private void zzf(Context context, Intent intent) {
        String string;
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Log.e((String)"GcmReceiver", (String)"Failed to resolve target intent service, skipping classname enforcement");
            return;
        }
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        if (!context.getPackageName().equals(serviceInfo.packageName) || serviceInfo.name == null) {
            String string2 = String.valueOf(serviceInfo.packageName);
            String string3 = String.valueOf(serviceInfo.name);
            Log.e((String)"GcmReceiver", (String)new StringBuilder(94 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ").append(string2).append("/").append(string3).toString());
            return;
        }
        String string4 = serviceInfo.name;
        if (string4.startsWith(".")) {
            String string5 = String.valueOf(context.getPackageName());
            String string6 = String.valueOf(string4);
            string = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        } else {
            string = string4 = string4;
        }
        if (Log.isLoggable((String)"GcmReceiver", (int)3)) {
            String string7 = String.valueOf(string4);
            Log.d((String)"GcmReceiver", (String)(string7.length() != 0 ? "Restricting intent to a specific service: ".concat(string7) : new String("Restricting intent to a specific service: ")));
        }
        intent.setClassName(context.getPackageName(), string4);
    }
}

