/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.cast.internal.zzq;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzpf;
import com.google.android.gms.internal.zzpg;
import com.google.android.gms.internal.zzph;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class zzpe
extends com.google.android.gms.cast.internal.zzc {
    static final String NAMESPACE = zzf.zzgs("com.google.cast.games");
    private static final zzm kr = new zzm("GameManagerChannel");
    private final Map<String, String> ro = new ConcurrentHashMap<String, String>();
    private final List<zzq> rp;
    private final SharedPreferences zzbak;
    private final String rq;
    private final Cast.CastApi nc;
    private final GoogleApiClient ps;
    private zzpf rr;
    private boolean rs = false;
    private GameManagerState rt;
    private GameManagerState ru;
    private String rv;
    private JSONObject rw;
    private long rx = 0L;
    private GameManagerClient.Listener ry;
    private final com.google.android.gms.common.util.zze zzapy;
    private String rz;

    public zzpe(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzapy = zzh.zzaxj();
        this.rp = new ArrayList<zzq>();
        this.rq = string2;
        this.nc = castApi;
        this.ps = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzbak = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.ru = null;
        this.rt = new zzpi(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        if (gameManagerClient == null) {
            throw new IllegalArgumentException("gameManagerClient can't be null.");
        }
        return this.ps.zzd((zzqc.zza)new zzc(gameManagerClient){

            @Override
            public void execute() {
                try {
                    zzpe.this.nc.setMessageReceivedCallbacks(zzpe.this.ps, zzpe.this.getNamespace(), new Cast.MessageReceivedCallback(){

                        @Override
                        public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
                            zzpe.this.zzgq(string3);
                        }
                    });
                }
                catch (IOException | IllegalStateException exception) {
                    this.zzans().zza(-1L, 8, null);
                    return;
                }
                zzpe.this.zzanq();
                zzpe.this.zzanp();
                zzpe.this.zza(null, 1100, null, this.zzans());
            }
        });
    }

    public synchronized void dispose() throws IllegalStateException {
        if (this.rs) {
            return;
        }
        this.rt = null;
        this.ru = null;
        this.rv = null;
        this.rw = null;
        this.rs = true;
        try {
            this.nc.removeMessageReceivedCallbacks(this.ps, this.getNamespace());
        }
        catch (IOException iOException) {
            kr.zzf("Exception while detaching game manager channel.", iOException);
        }
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> zza(final String string2, final int n, final JSONObject jSONObject) throws IllegalStateException {
        this.zzann();
        return this.ps.zzd((zzqc.zza)new zza(){

            @Override
            public void execute() {
                int n2 = zzph.zzez(n);
                if (n2 == 0) {
                    this.zzans().zza(-1L, 2001, null);
                    kr.zzf("sendPlayerRequest for unsupported playerState: %d", n);
                    return;
                }
                zzpe.this.zza(string2, n2, jSONObject, this.zzans());
            }
        });
    }

    public synchronized void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzann();
        long l = ++this.rx;
        JSONObject jSONObject2 = this.zza(l, string2, 7, jSONObject);
        if (jSONObject2 == null) {
            return;
        }
        this.nc.sendMessage(this.ps, this.getNamespace(), jSONObject2.toString());
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(final String string2, final JSONObject jSONObject) throws IllegalStateException {
        this.zzann();
        return this.ps.zzd((zzqc.zza)new zza(){

            @Override
            public void execute() {
                zzpe.this.zza(string2, 6, jSONObject, this.zzans());
            }
        });
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzann();
        return this.rt;
    }

    public synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzann();
        return this.rz;
    }

    public synchronized String zzgp(String string2) throws IllegalStateException {
        return string2 == null ? null : this.ro.get(string2);
    }

    public synchronized void setListener(GameManagerClient.Listener listener) {
        this.ry = listener;
    }

    @Override
    public final void zzgq(String string2) {
        boolean bl;
        zzpg zzpg2;
        kr.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            zzpg2 = zzpg.zzp(jSONObject);
        }
        catch (JSONException jSONException) {
            kr.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzpg2 == null) {
            kr.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzpg2.zzanz() == null || this.isDisposed()) {
            return;
        }
        boolean bl2 = bl = zzpg2.zzanu() == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzpg2.zzany())) {
            this.ro.put(zzpg2.getPlayerId(), zzpg2.zzany());
            this.zzanp();
        }
        if (zzpg2.getStatusCode() == 0) {
            this.zza(zzpg2);
        } else {
            kr.zzf("Not updating from game message because the message contains error code: %d", zzpg2.getStatusCode());
        }
        int n = this.zzey(zzpg2.getStatusCode());
        if (bl) {
            this.zzb(zzpg2.getRequestId(), n, zzpg2);
        }
        if (this.isInitialized() && n == 0) {
            this.zzano();
        }
    }

    public synchronized boolean isDisposed() {
        return this.rs;
    }

    public synchronized boolean isInitialized() {
        return this.rr != null;
    }

    @Override
    public void zzb(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzae(long l) {
        Iterator<zzq> iterator = this.rp.iterator();
        while (iterator.hasNext()) {
            zzq zzq2 = iterator.next();
            if (!zzq2.zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzq.zzagd;
        synchronized (object) {
            for (zzq zzq3 : this.rp) {
                if (!zzq3.zzaot()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int zzey(int n) {
        switch (n) {
            case 4: {
                return 2151;
            }
            case 3: {
                return 2150;
            }
            case 2: {
                return 2003;
            }
            case 1: {
                return 2001;
            }
            case 0: {
                return 0;
            }
        }
        kr.zzf(new StringBuilder(53).append("Unknown GameManager protocol status code: ").append(n).toString(), new Object[0]);
        return 13;
    }

    private synchronized void zzann() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private void zza(String string2, int n, JSONObject jSONObject, zzp zzp2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.rx, string2, n, jSONObject)) == null) {
            zzp2.zza(-1L, 2001, null);
            kr.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzq zzq2 = new zzq(this.zzapy, 30000L);
        zzq2.zza(l, zzp2);
        this.rp.add(zzq2);
        this.zzbo(true);
        this.nc.sendMessage(this.ps, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    zzpe.this.zzb(l, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzp((Status)result);
            }
        });
    }

    private JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzgp(string2));
        }
        catch (JSONException jSONException) {
            kr.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private synchronized void zza(zzpg zzpg2) {
        boolean bl = zzpg2.zzanu() == 1;
        this.ru = this.rt;
        if (bl && zzpg2.zzanz() != null) {
            this.rr = zzpg2.zzanz();
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzpk zzpk2 : zzpg2.zzanw()) {
            String string2 = zzpk2.getPlayerId();
            zzpj zzpj2 = new zzpj(string2, zzpk2.getPlayerState(), zzpk2.getPlayerData(), this.ro.containsKey(string2));
            arrayList.add(zzpj2);
        }
        this.rt = new zzpi(zzpg2.getLobbyState(), zzpg2.getGameplayState(), zzpg2.zzanx(), zzpg2.getGameData(), arrayList, this.rr.zzant(), this.rr.getMaxPlayers());
        PlayerInfo playerInfo = this.rt.getPlayer(zzpg2.getPlayerId());
        if (playerInfo != null && playerInfo.isControllable() && zzpg2.zzanu() == 2) {
            this.rv = zzpg2.getPlayerId();
            this.rw = zzpg2.getExtraMessageData();
        }
    }

    private void zzano() {
        if (this.ry != null) {
            if (this.ru != null && !this.rt.equals(this.ru)) {
                this.ry.onStateChanged(this.rt, this.ru);
            }
            if (this.rw != null && this.rv != null) {
                this.ry.onGameMessageReceived(this.rv, this.rw);
            }
        }
        this.ru = null;
        this.rv = null;
        this.rw = null;
    }

    private void zzb(long l, int n, Object object) {
        Iterator<zzq> iterator = this.rp.iterator();
        while (iterator.hasNext()) {
            zzq zzq2 = iterator.next();
            if (!zzq2.zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private synchronized void zzanp() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.rq);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.ro));
            this.zzbak.edit().putString("save_data", jSONObject.toString()).commit();
        }
        catch (JSONException jSONException) {
            kr.zzf("Error while saving data: %s", jSONException.getMessage());
        }
    }

    private synchronized void zzanq() {
        String string2 = this.zzbak.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.rq.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.ro.put(string4, jSONObject2.getString(string4));
                }
                this.rx = 0L;
            }
        }
        catch (JSONException jSONException) {
            kr.zzf("Error while loading data: %s", jSONException.getMessage());
        }
    }

    public abstract class zza
    extends zzb<GameManagerClient.GameManagerResult> {
        public zza() {
            this.my = new zzp(){

                @Override
                public void zzac(long l) {
                    zza.this.zzc((GameManagerClient.GameManagerResult)zza.this.zzc(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zza.this.zzc(new zze(new Status(n, null, null), null, l, null));
                            return;
                        }
                        zzpg zzpg2 = (zzpg)object;
                        String string2 = zzpg2.getPlayerId();
                        if (n == 0 && string2 != null) {
                            zzpe.this.rz = string2;
                        }
                        zza.this.zzc(new zze(new Status(n, zzpg2.zzanv(), null), string2, zzpg2.getRequestId(), zzpg2.getExtraMessageData()));
                    }
                    catch (ClassCastException classCastException) {
                        zza.this.zzc((GameManagerClient.GameManagerResult)zza.this.zzc(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerResult zzs(Status status) {
            return new zze(status, null, -1L, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzs(status);
        }
    }

    public abstract class zzc
    extends zzb<GameManagerClient.GameManagerInstanceResult> {
        private GameManagerClient rI;

        public zzc(GameManagerClient gameManagerClient) {
            this.rI = gameManagerClient;
            this.my = new zzp(){

                @Override
                public void zzac(long l) {
                    zzc.this.zzc((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zzc.this.zzc(new zzd(new Status(n, null, null), zzc.this.rI));
                            return;
                        }
                        zzpg zzpg2 = (zzpg)object;
                        zzpf zzpf2 = zzpg2.zzanz();
                        if (zzpf2 != null && !zzf.zza("1.0.0", zzpf2.getVersion())) {
                            zzpe.this.rr = null;
                            zzc.this.zzc((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(2150, String.format(Locale.ROOT, "Incorrect Game Manager SDK version. Receiver: %s Sender: %s", zzpf2.getVersion(), "1.0.0"))));
                            return;
                        }
                        zzc.this.zzc(new zzd(new Status(n, zzpg2.zzanv(), null), zzc.this.rI));
                    }
                    catch (ClassCastException classCastException) {
                        zzc.this.zzc((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerInstanceResult zzt(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzt(status);
        }
    }

    public abstract class zzb<R extends Result>
    extends com.google.android.gms.cast.internal.zzb<R> {
        protected zzp my;

        public zzb() {
            super(zzpe.this.ps);
        }

        protected void zza(com.google.android.gms.cast.internal.zze zze2) {
            this.execute();
        }

        public zzp zzans() {
            return this.my;
        }

        public abstract void execute();
    }

    private static final class zze
    implements GameManagerClient.GameManagerResult {
        private final Status fp;
        private final String rK;
        private final long rL;
        private final JSONObject rM;

        zze(Status status, String string2, long l, JSONObject jSONObject) {
            this.fp = status;
            this.rK = string2;
            this.rL = l;
            this.rM = jSONObject;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public String getPlayerId() {
            return this.rK;
        }

        @Override
        public long getRequestId() {
            return this.rL;
        }

        @Override
        public JSONObject getExtraMessageData() {
            return this.rM;
        }
    }

    private static final class zzd
    implements GameManagerClient.GameManagerInstanceResult {
        private final Status fp;
        private final GameManagerClient rI;

        zzd(Status status, GameManagerClient gameManagerClient) {
            this.fp = status;
            this.rI = gameManagerClient;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public GameManagerClient getGameManagerClient() {
            return this.rI;
        }
    }
}

