/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzc;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.cast.internal.zzq;
import com.google.android.gms.common.util.zzh;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzn
extends zzc {
    public static final String NAMESPACE = zzf.zzgs("com.google.cast.media");
    private long sZ;
    private MediaStatus ta;
    private final List<zzq> rp;
    private zza tb;
    private final zzq tc;
    private final zzq td;
    private final zzq te;
    private final zzq tf;
    private final zzq tg;
    private final zzq th;
    private final zzq ti;
    private final zzq tj;
    private final zzq tk;
    private final zzq tl;
    private final zzq tm;
    private final zzq tn;
    private final zzq to;
    private final zzq tp;

    public zzn(String string2) {
        super(NAMESPACE, zzh.zzaxj(), "MediaControlChannel", string2, 1000L);
        this.tc = new zzq(this.zzapy, 86400000L);
        this.td = new zzq(this.zzapy, 86400000L);
        this.te = new zzq(this.zzapy, 86400000L);
        this.tf = new zzq(this.zzapy, 86400000L);
        this.tg = new zzq(this.zzapy, 86400000L);
        this.th = new zzq(this.zzapy, 86400000L);
        this.ti = new zzq(this.zzapy, 86400000L);
        this.tj = new zzq(this.zzapy, 86400000L);
        this.tk = new zzq(this.zzapy, 86400000L);
        this.tl = new zzq(this.zzapy, 86400000L);
        this.tm = new zzq(this.zzapy, 86400000L);
        this.tn = new zzq(this.zzapy, 86400000L);
        this.to = new zzq(this.zzapy, 86400000L);
        this.tp = new zzq(this.zzapy, 86400000L);
        this.rp = new ArrayList<zzq>();
        this.rp.add(this.tc);
        this.rp.add(this.td);
        this.rp.add(this.te);
        this.rp.add(this.tf);
        this.rp.add(this.tg);
        this.rp.add(this.th);
        this.rp.add(this.ti);
        this.rp.add(this.tj);
        this.rp.add(this.tk);
        this.rp.add(this.tl);
        this.rp.add(this.tm);
        this.rp.add(this.tn);
        this.rp.add(this.to);
        this.rp.add(this.tp);
        this.zzaor();
    }

    public void zza(zza zza2) {
        this.tb = zza2;
    }

    public long zza(zzp zzp2, MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzaoc();
        this.tc.zza(l2, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", zzf.zzaf(l));
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzp zzp2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaoc();
        this.td.zza(l, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzajz());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzb(zzp zzp2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaoc();
        this.tf.zza(l, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzajz());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzc(zzp zzp2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaoc();
        this.te.zza(l, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzajz());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzp zzp2, long l, int n, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzaoc();
        this.tg.zza(l2, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzajz());
            jSONObject2.put("currentTime", zzf.zzaf(l));
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzp zzp2, double d, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaoc();
        this.th.zza(l, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzajz());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzp zzp2, boolean bl, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaoc();
        this.ti.zza(l, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzajz());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzp zzp2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzaoc();
        this.tj.zza(l, zzp2);
        this.zzbo(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.ta != null) {
                jSONObject.put("mediaSessionId", this.ta.zzajz());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzp zzp2, long[] lArray) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzaoc();
        this.tk.zza(l, zzp2);
        this.zzbo(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzajz());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzp zzp2, TextTrackStyle textTrackStyle) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzaoc();
        this.tl.zza(l, zzp2);
        this.zzbo(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzajz());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.sZ == 0L) {
            return 0L;
        }
        double d = this.ta.getPlaybackRate();
        long l = this.ta.getStreamPosition();
        int n = this.ta.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = this.zzapy.elapsedRealtime() - this.sZ;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 == 0L) {
            return l;
        }
        long l3 = mediaInfo.getStreamDuration();
        long l4 = l + (long)((double)l2 * d);
        if (l3 > 0L && l4 > l3) {
            l4 = l3;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.ta;
    }

    public MediaInfo getMediaInfo() {
        return this.ta == null ? null : this.ta.getMediaInfo();
    }

    public long zza(zzp zzp2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IOException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid startIndex: ").append(n).toString());
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzaoc();
        this.tc.zza(l2, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Invalid repeat mode: ").append(n2).toString());
                }
            }
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", zzf.zzaf(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzp zzp2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalStateException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (n2 != 0 && n3 != -1) {
            throw new IllegalArgumentException("can not set both currentItemId and currentItemIndexInItemsToInsert");
        }
        if (n3 != -1 && (n3 < 0 || n3 >= mediaQueueItemArray.length)) {
            throw new IllegalArgumentException(String.format("currentItemIndexInItemsToInsert %d out of range [0, %d).", n3, mediaQueueItemArray.length));
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzaoc();
        this.tm.zza(l2, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzajz());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n2 != 0) {
                jSONObject2.put("currentItemId", n2);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", n3);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", zzf.zzaf(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzp zzp2, int n, long l, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IOException, IllegalStateException {
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("playPosition cannot be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzaoc();
        this.tn.zza(l2, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzajz());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                        break;
                    }
                }
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", zzf.zzaf(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzp zzp2, int[] nArray, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaoc();
        this.to.zza(l, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzajz());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzp zzp2, int[] nArray, int n, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzaoc();
        this.tp.zza(l, zzp2);
        this.zzbo(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzajz());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    @Override
    public final void zzgq(String string2) {
        this.mL.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            if (string3.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.zza(l, jSONArray.getJSONObject(0));
                } else {
                    this.ta = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.tj.zzc(l, 0);
                }
            } else if (string3.equals("INVALID_PLAYER_STATE")) {
                this.mL.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                for (zzq zzq2 : this.rp) {
                    zzq2.zzc(l, 2100, jSONObject2);
                }
            } else if (string3.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.tc.zzc(l, 2100, jSONObject3);
            } else if (string3.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.tc.zzc(l, 2101, jSONObject4);
            } else if (string3.equals("INVALID_REQUEST")) {
                this.mL.zzf("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                for (zzq zzq3 : this.rp) {
                    zzq3.zzc(l, 2100, jSONObject5);
                }
            }
        }
        catch (JSONException jSONException) {
            this.mL.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    private void zza(long l, JSONObject jSONObject) throws JSONException {
        boolean bl = this.tc.test(l);
        boolean bl2 = this.tg.zzaot() && !this.tg.test(l);
        boolean bl3 = this.th.zzaot() && !this.th.test(l) || this.ti.zzaot() && !this.ti.test(l);
        int n = 0;
        if (bl2) {
            n = 2;
        }
        if (bl3) {
            n |= 1;
        }
        int n2 = 0;
        if (bl || this.ta == null) {
            this.ta = new MediaStatus(jSONObject);
            this.sZ = this.zzapy.elapsedRealtime();
            n2 = 31;
        } else {
            n2 = this.ta.zza(jSONObject, n);
        }
        if ((n2 & 1) != 0) {
            this.sZ = this.zzapy.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 2) != 0) {
            this.sZ = this.zzapy.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n2 & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n2 & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n2 & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        for (zzq zzq2 : this.rp) {
            zzq2.zzc(l, 0);
        }
    }

    public long zzajz() throws IllegalStateException {
        if (this.ta == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.ta.zzajz();
    }

    private void onStatusUpdated() {
        if (this.tb != null) {
            this.tb.onStatusUpdated();
        }
    }

    private void onMetadataUpdated() {
        if (this.tb != null) {
            this.tb.onMetadataUpdated();
        }
    }

    private void onQueueStatusUpdated() {
        if (this.tb != null) {
            this.tb.onQueueStatusUpdated();
        }
    }

    private void onPreloadStatusUpdated() {
        if (this.tb != null) {
            this.tb.onPreloadStatusUpdated();
        }
    }

    private void zzaor() {
        this.sZ = 0L;
        this.ta = null;
        for (zzq zzq2 : this.rp) {
            zzq2.clear();
        }
    }

    @Override
    public void zzaob() {
        super.zzaob();
        this.zzaor();
    }

    @Override
    public void zzb(long l, int n) {
        for (zzq zzq2 : this.rp) {
            zzq2.zzc(l, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzae(long l) {
        for (zzq object2 : this.rp) {
            object2.zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzq.zzagd;
        synchronized (object) {
            for (zzq zzq2 : this.rp) {
                if (!zzq2.zzaot()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static interface zza {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();
    }
}

