/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.text.TextUtils;
import java.util.Locale;
import java.util.regex.Pattern;

public final class zzf {
    private static final Pattern sM = Pattern.compile("urn:x-cast:[-A-Za-z0-9_]+(\\.[-A-Za-z0-9_]+)*");

    public static <T> boolean zza(T t, T t2) {
        return t == null && t2 == null || t != null && t2 != null && t.equals(t2);
    }

    public static double zzaf(long l) {
        return (double)l / 1000.0;
    }

    public static long zzf(double d) {
        return (long)(d * 1000.0);
    }

    public static void zzgr(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Namespace cannot be null or empty");
        }
        if (string2.length() > 128) {
            throw new IllegalArgumentException("Invalid namespace length");
        }
        if (!string2.startsWith("urn:x-cast:")) {
            throw new IllegalArgumentException("Namespace must begin with the prefix \"urn:x-cast:\"");
        }
        if (string2.length() == "urn:x-cast:".length()) {
            throw new IllegalArgumentException("Namespace must begin with the prefix \"urn:x-cast:\" and have non-empty suffix");
        }
    }

    public static String zzgs(String string2) {
        String string3 = String.valueOf("urn:x-cast:");
        String string4 = String.valueOf(string2);
        return string4.length() != 0 ? string3.concat(string4) : new String(string3);
    }

    public static String zzgt(String string2) {
        if (sM.matcher(string2).matches()) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (zzf.zzb(c) || c == '.' || c == ':') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(String.format("%%%04x", c & 0xFFFF));
        }
        return stringBuilder.toString();
    }

    private static boolean zzb(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-';
    }

    public static String zzb(Locale locale) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(locale.getLanguage());
        String string3 = locale.getCountry();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append('-').append(string3);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = locale.getVariant()))) {
            stringBuilder.append('-').append(string2);
        }
        return stringBuilder.toString();
    }
}

