/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.JoinOptions;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.ApplicationStatus;
import com.google.android.gms.cast.internal.DeviceStatus;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzj;
import com.google.android.gms.cast.internal.zzk;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.internal.zzqc;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class zze
extends zzl<zzj> {
    private static final zzm kr = new zzm("CastClientImpl");
    private ApplicationMetadata si;
    private final CastDevice ng;
    private final Cast.Listener jZ;
    private final Map<String, Cast.MessageReceivedCallback> sj;
    private final long sk;
    private zzb sl;
    private String sm;
    private boolean lG;
    private boolean sn;
    private boolean so;
    private boolean sp;
    private double lF;
    private int sq;
    private int sr;
    private final AtomicLong ss;
    private String st;
    private String su;
    private Bundle sv;
    private final Map<Long, zzqc.zzb<Status>> sw;
    private zzj sx;
    private zzqc.zzb<Cast.ApplicationConnectionResult> sy;
    private zzqc.zzb<Status> sz;
    private static final Object sA = new Object();
    private static final Object sB = new Object();

    public zze(Context context, Looper looper, zzh zzh2, CastDevice castDevice, long l, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzh2, connectionCallbacks, onConnectionFailedListener);
        this.ng = castDevice;
        this.jZ = listener;
        this.sk = l;
        this.sj = new HashMap<String, Cast.MessageReceivedCallback>();
        this.ss = new AtomicLong(0L);
        this.sw = new HashMap<Long, zzqc.zzb<Status>>();
        this.zzaod();
    }

    private void zzaod() {
        this.sp = false;
        this.sq = -1;
        this.sr = -1;
        this.si = null;
        this.sm = null;
        this.lF = 0.0;
        this.lG = false;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        kr.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.sp = true;
            this.sn = true;
            this.so = true;
        } else {
            this.sp = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.sv = new Bundle();
            this.sv.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    public void disconnect() {
        kr.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.sl, this.isConnected());
        zzb zzb2 = this.sl;
        this.sl = null;
        if (zzb2 == null || zzb2.zzaol() == null) {
            kr.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzaog();
        try {
            this.zzaof().disconnect();
        }
        catch (RemoteException | IllegalStateException throwable) {
            kr.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle zzaoe() {
        if (this.sv != null) {
            Bundle bundle = this.sv;
            this.sv = null;
            return bundle;
        }
        return super.zzaoe();
    }

    @NonNull
    protected String zzix() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @NonNull
    protected String zziy() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzj zzdg(IBinder iBinder) {
        return zzj.zza.zzdh(iBinder);
    }

    protected Bundle zzagl() {
        Bundle bundle = new Bundle();
        kr.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.st, this.su);
        this.ng.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.sk);
        this.sl = new zzb(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.sl.asBinder()));
        if (this.st != null) {
            bundle.putString("last_application_id", this.st);
            if (this.su != null) {
                bundle.putString("last_session_id", this.su);
            }
        }
        return bundle;
    }

    zzj zzaof() throws DeadObjectException {
        return null == null ? (zzj)super.zzatx() : this.sx;
    }

    public void zza(String string2, String string3, zzqc.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzf.zzgr(string2);
        this.zzaoh();
        long l = this.ss.incrementAndGet();
        try {
            this.sw.put(l, zzb2);
            this.zzaof().zzb(string2, string3, l);
        }
        catch (Throwable throwable) {
            this.sw.remove(l);
            throw throwable;
        }
    }

    public void zza(String string2, boolean bl, zzqc.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        LaunchOptions launchOptions = new LaunchOptions();
        launchOptions.setRelaunchIfRunning(bl);
        this.zza(string2, launchOptions, zzb2);
    }

    public void zza(String string2, LaunchOptions launchOptions, zzqc.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        this.zzaof().zzb(string2, launchOptions);
    }

    public void zza(String string2, String string3, JoinOptions joinOptions, zzqc.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        if (joinOptions == null) {
            joinOptions = new JoinOptions();
        }
        this.zzaof().zza(string2, string3, joinOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzqc.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = sA;
        synchronized (object) {
            if (this.sy != null) {
                this.sy.setResult((Object)new zza(new Status(2002)));
            }
            this.sy = zzb2;
        }
    }

    public void zzb(zzqc.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        this.zzaof().zzaon();
    }

    public void zza(String string2, zzqc.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        this.zzaof().zzgl(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zzqc.zzb<Status> zzb2) {
        Object object = sB;
        synchronized (object) {
            if (this.sz != null) {
                zzb2.setResult((Object)new Status(2001));
                return;
            }
            this.sz = zzb2;
        }
    }

    public void requestStatus() throws IllegalStateException, RemoteException {
        this.zzaof().requestStatus();
    }

    public void setVolume(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        this.zzaof().zza(d, this.lF, this.lG);
    }

    public void setMute(boolean bl) throws IllegalStateException, RemoteException {
        this.zzaof().zza(bl, this.lF, this.lG);
    }

    public double getVolume() throws IllegalStateException {
        this.zzaoh();
        return this.lF;
    }

    public boolean isMute() throws IllegalStateException {
        this.zzaoh();
        return this.lG;
    }

    public int getActiveInputState() throws IllegalStateException {
        this.zzaoh();
        return this.sq;
    }

    public int getStandbyState() throws IllegalStateException {
        this.zzaoh();
        return this.sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzf.zzgr(string2);
        this.removeMessageReceivedCallbacks(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.sj;
            synchronized (map) {
                this.sj.put(string2, messageReceivedCallback);
            }
            this.zzaof().zzgu(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageReceivedCallbacks(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.sj;
        synchronized (map) {
            messageReceivedCallback = this.sj.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                this.zzaof().zzgv(string2);
            }
            catch (IllegalStateException illegalStateException) {
                kr.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzaoh();
        return this.si;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zzaoh();
        return this.sm;
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzaog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzaog() {
        kr.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.sj;
        synchronized (map) {
            this.sj.clear();
        }
    }

    private void zza(DeviceStatus deviceStatus) {
        boolean bl;
        ApplicationMetadata applicationMetadata = deviceStatus.getApplicationMetadata();
        if (!zzf.zza(applicationMetadata, this.si)) {
            this.si = applicationMetadata;
            this.jZ.onApplicationMetadataChanged(this.si);
        }
        boolean bl2 = false;
        double d = deviceStatus.getVolume();
        if (!Double.isNaN(d) && Math.abs(d - this.lF) > 1.0E-7) {
            this.lF = d;
            bl2 = true;
        }
        if ((bl = deviceStatus.zzaom()) != this.lG) {
            this.lG = bl;
            bl2 = true;
        }
        kr.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.so);
        if (this.jZ != null && (bl2 || this.so)) {
            this.jZ.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = deviceStatus.getActiveInputState();
        if (n != this.sq) {
            this.sq = n;
            bl3 = true;
        }
        kr.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.so);
        if (this.jZ != null && (bl3 || this.so)) {
            this.jZ.onActiveInputStateChanged(this.sq);
        }
        boolean bl4 = false;
        int n2 = deviceStatus.getStandbyState();
        if (n2 != this.sr) {
            this.sr = n2;
            bl4 = true;
        }
        kr.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.so);
        if (this.jZ != null && (bl4 || this.so)) {
            this.jZ.onStandbyStateChanged(this.sr);
        }
        this.so = false;
    }

    private void zza(ApplicationStatus applicationStatus) {
        boolean bl = false;
        String string2 = applicationStatus.zzaoa();
        if (!zzf.zza(string2, this.sm)) {
            this.sm = string2;
            bl = true;
        }
        kr.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.sn);
        if (this.jZ != null && (bl || this.sn)) {
            this.jZ.onApplicationStatusChanged();
        }
        this.sn = false;
    }

    void zzaoh() throws IllegalStateException {
        if (!this.sp || this.sl == null || this.sl.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzdg(iBinder);
    }

    static class zzb
    extends zzk.zza {
        private final AtomicReference<zze> sF;
        private final Handler mHandler;

        public zzb(zze zze2) {
            this.sF = new AtomicReference<zze>(zze2);
            this.mHandler = new Handler(zze2.getLooper());
        }

        public zze zzaol() {
            zze zze2 = this.sF.getAndSet(null);
            if (zze2 == null) {
                return null;
            }
            zze2.zzaod();
            return zze2;
        }

        public boolean isDisposed() {
            return this.sF.get() == null;
        }

        @Override
        public void zzfc(int n) {
            zze zze2 = this.zzaol();
            if (zze2 == null) {
                return;
            }
            kr.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zze2.zzgl(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            zze2.si = applicationMetadata;
            zze2.st = applicationMetadata.getApplicationId();
            zze2.su = string3;
            zze2.sm = string2;
            Object object = sA;
            synchronized (object) {
                if (zze2.sy != null) {
                    zze2.sy.setResult((Object)new zza(new Status(0), applicationMetadata, string2, string3, bl));
                    zze2.sy = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzeq(int n) {
            zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            Object object = sA;
            synchronized (object) {
                if (zze2.sy != null) {
                    zze2.sy.setResult((Object)new zza(new Status(n)));
                    zze2.sy = null;
                }
            }
        }

        @Override
        public void zzfd(int n) {
            zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void zzfe(int n) {
            zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void onApplicationDisconnected(final int n) {
            final zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            zze2.st = null;
            zze2.su = null;
            this.zza(zze2, n);
            if (zze2.jZ != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        zze2.jZ.onApplicationDisconnected(n);
                    }
                });
            }
        }

        @Override
        public void zza(String string2, double d, boolean bl) {
            kr.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final DeviceStatus deviceStatus) {
            final zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            kr.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(deviceStatus);
                }
            });
        }

        @Override
        public void zzb(final ApplicationStatus applicationStatus) {
            final zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            kr.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(applicationStatus);
                }
            });
        }

        @Override
        public void zzaa(final String string2, final String string3) {
            final zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            kr.zzb("Receive (type=text, ns=%s) %s", string2, string3);
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zze2.sj;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zze2.sj.get(string2);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zze2.ng, string2, string3);
                    } else {
                        kr.zzb("Discarded message for unknown namespace '%s'", string2);
                    }
                }
            });
        }

        @Override
        public void zzb(String string2, byte[] byArray) {
            zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            kr.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string2, byArray.length);
        }

        @Override
        public void zza(String string2, long l, int n) {
            zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, n);
        }

        @Override
        public void zzc(String string2, long l) {
            zze zze2 = this.sF.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zze zze2, long l, int n) {
            zzqc.zzb zzb2;
            Map map = zze2.sw;
            synchronized (map) {
                zzb2 = (zzqc.zzb)zze2.sw.remove(l);
            }
            if (zzb2 != null) {
                zzb2.setResult((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zze zze2, int n) {
            Object object = sB;
            synchronized (object) {
                if (zze2.sz != null) {
                    zze2.sz.setResult((Object)new Status(n));
                    zze2.sz = null;
                    return true;
                }
            }
            return false;
        }
    }

    static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status fp;
        private final ApplicationMetadata sC;
        private final String sD;
        private final String zzcpl;
        private final boolean sE;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            this.fp = status;
            this.sC = applicationMetadata;
            this.sD = string2;
            this.zzcpl = string3;
            this.sE = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.sC;
        }

        @Override
        public String getApplicationStatus() {
            return this.sD;
        }

        @Override
        public String getSessionId() {
            return this.zzcpl;
        }

        @Override
        public boolean getWasLaunched() {
            return this.sE;
        }
    }
}

