/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzk;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.common.util.zzs;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle
extends AbstractSafeParcelable {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    public static final Parcelable.Creator<TextTrackStyle> CREATOR = new zzk();
    private final int mVersionCode;
    private float mA;
    private int mB;
    private int mBackgroundColor;
    private int mC;
    private int mD;
    private int mE;
    private int mF;
    private int mG;
    private String mH;
    private int mI;
    private int mJ;
    String lf;
    private JSONObject lh;

    TextTrackStyle(int n, float f, int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string2, int n9, int n10, String string3) {
        this.mVersionCode = n;
        this.mA = f;
        this.mB = n2;
        this.mBackgroundColor = n3;
        this.mC = n4;
        this.mD = n5;
        this.mE = n6;
        this.mF = n7;
        this.mG = n8;
        this.mH = string2;
        this.mI = n9;
        this.mJ = n10;
        this.lf = string3;
        if (this.lf != null) {
            try {
                this.lh = new JSONObject(this.lf);
            }
            catch (JSONException jSONException) {
                this.lh = null;
                this.lf = null;
            }
        } else {
            this.lh = null;
        }
    }

    public TextTrackStyle() {
        this(1, 1.0f, 0, 0, -1, 0, -1, 0, 0, null, -1, -1, null);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void setFontScale(float f) {
        this.mA = f;
    }

    public float getFontScale() {
        return this.mA;
    }

    public void setForegroundColor(int n) {
        this.mB = n;
    }

    public int getForegroundColor() {
        return this.mB;
    }

    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setEdgeType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.mC = n;
    }

    public int getEdgeType() {
        return this.mC;
    }

    public void setEdgeColor(int n) {
        this.mD = n;
    }

    public int getEdgeColor() {
        return this.mD;
    }

    public void setWindowType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.mE = n;
    }

    public int getWindowType() {
        return this.mE;
    }

    public void setWindowColor(int n) {
        this.mF = n;
    }

    public int getWindowColor() {
        return this.mF;
    }

    public void setWindowCornerRadius(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.mG = n;
    }

    public int getWindowCornerRadius() {
        return this.mG;
    }

    public void setFontFamily(String string2) {
        this.mH = string2;
    }

    public String getFontFamily() {
        return this.mH;
    }

    public void setFontGenericFamily(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.mI = n;
    }

    public int getFontGenericFamily() {
        return this.mI;
    }

    public void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.mJ = n;
    }

    public int getFontStyle() {
        return this.mJ;
    }

    public void setCustomData(JSONObject jSONObject) {
        this.lh = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.lh;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzs.zzaxr()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void zzm(JSONObject jSONObject) throws JSONException {
        String string2;
        this.mA = (float)jSONObject.optDouble("fontScale", 1.0);
        this.mB = this.zzgk(jSONObject.optString("foregroundColor"));
        this.mBackgroundColor = this.zzgk(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.mC = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.mC = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.mC = 2;
            } else if ("RAISED".equals(string2)) {
                this.mC = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.mC = 4;
            }
        }
        this.mD = this.zzgk(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.mE = 0;
            } else if ("NORMAL".equals(string2)) {
                this.mE = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.mE = 2;
            }
        }
        this.mF = this.zzgk(jSONObject.optString("windowColor"));
        if (this.mE == 2) {
            this.mG = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.mH = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.mI = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.mI = 1;
            } else if ("SERIF".equals(string2)) {
                this.mI = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.mI = 3;
            } else if ("CASUAL".equals(string2)) {
                this.mI = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.mI = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.mI = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.mJ = 0;
            } else if ("BOLD".equals(string2)) {
                this.mJ = 1;
            } else if ("ITALIC".equals(string2)) {
                this.mJ = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.mJ = 3;
            }
        }
        this.lh = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.mA);
            if (this.mB != 0) {
                jSONObject.put("foregroundColor", (Object)this.zzaw(this.mB));
            }
            if (this.mBackgroundColor != 0) {
                jSONObject.put("backgroundColor", (Object)this.zzaw(this.mBackgroundColor));
            }
            switch (this.mC) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.mD != 0) {
                jSONObject.put("edgeColor", (Object)this.zzaw(this.mD));
            }
            switch (this.mE) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.mF != 0) {
                jSONObject.put("windowColor", (Object)this.zzaw(this.mF));
            }
            if (this.mE == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.mG);
            }
            if (this.mH != null) {
                jSONObject.put("fontFamily", (Object)this.mH);
            }
            switch (this.mI) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.mJ) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.lh != null) {
                jSONObject.put("customData", (Object)this.lh);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String zzaw(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int zzgk(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                int n4 = Integer.parseInt(string2.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)((Object)object);
        if (this.lh == null != (textTrackStyle.lh == null)) {
            return false;
        }
        if (this.lh != null && textTrackStyle.lh != null && !zzp.zzf((Object)this.lh, (Object)textTrackStyle.lh)) {
            return false;
        }
        return this.mA == textTrackStyle.mA && this.mB == textTrackStyle.mB && this.mBackgroundColor == textTrackStyle.mBackgroundColor && this.mC == textTrackStyle.mC && this.mD == textTrackStyle.mD && this.mE == textTrackStyle.mE && this.mG == textTrackStyle.mG && zzf.zza(this.mH, textTrackStyle.mH) && this.mI == textTrackStyle.mI && this.mJ == textTrackStyle.mJ;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{Float.valueOf(this.mA), this.mB, this.mBackgroundColor, this.mC, this.mD, this.mE, this.mF, this.mG, this.mH, this.mI, this.mJ, this.lh});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.lf = this.lh == null ? null : this.lh.toString();
        zzk.zza(this, parcel, n);
    }
}

