/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zze;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzqc;
import java.io.IOException;
import java.util.Locale;
import org.json.JSONObject;

@SuppressLint(value={"MissingRemoteException"})
public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object zzakd = new Object();
    private final zzn lQ;
    private final zza lR;
    private OnPreloadStatusUpdatedListener lS;
    private OnQueueStatusUpdatedListener lT;
    private OnMetadataUpdatedListener lU;
    private OnStatusUpdatedListener lV;
    public static final String NAMESPACE = zzn.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_CANCELED = 2101;
    public static final int STATUS_TIMED_OUT = 2102;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaPlayer() {
        this(new zzn(null));
    }

    RemoteMediaPlayer(zzn zzn2) {
        this.lQ = zzn2;
        this.lQ.zza(new zzn.zza(){

            @Override
            public void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            public void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }

            @Override
            public void onQueueStatusUpdated() {
                RemoteMediaPlayer.this.onQueueStatusUpdated();
            }

            @Override
            public void onPreloadStatusUpdated() {
                RemoteMediaPlayer.this.onPreloadStatusUpdated();
            }
        });
        this.lR = new zza();
        this.lQ.zza(this.lR);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo) {
        return this.load(googleApiClient, mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl) {
        return this.load(googleApiClient, mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(googleApiClient, mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(googleApiClient, mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient googleApiClient, final MediaInfo mediaInfo, final boolean bl, final long l, final long[] lArray, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, mediaInfo, bl, l, lArray, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient googleApiClient) {
        return this.pause(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient googleApiClient) {
        return this.stop(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zzb(this.my, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient googleApiClient) {
        return this.play(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zzc(this.my, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient googleApiClient, long l) {
        return this.seek(googleApiClient, l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient googleApiClient, long l, int n) {
        return this.seek(googleApiClient, l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient googleApiClient, final long l, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, l, n, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient googleApiClient, double d) throws IllegalArgumentException {
        return this.setStreamVolume(googleApiClient, d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient googleApiClient, final double d, final JSONObject jSONObject) throws IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, d, jSONObject);
                    }
                    catch (IOException | IllegalArgumentException | IllegalStateException exception) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient googleApiClient, boolean bl) {
        return this.setStreamMute(googleApiClient, bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient googleApiClient, final boolean bl, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, bl, jSONObject);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient googleApiClient, final long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, lArray);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient googleApiClient, final TextTrackStyle textTrackStyle) {
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, textTrackStyle);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(GoogleApiClient googleApiClient, MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(googleApiClient, mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final int n, final int n2, final long l, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, mediaQueueItemArray, n, n2, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, mediaQueueItemArray, n, 0, -1, -1L, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(GoogleApiClient googleApiClient, MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(googleApiClient, new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(GoogleApiClient googleApiClient, MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(googleApiClient, mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(final GoogleApiClient googleApiClient, final MediaQueueItem mediaQueueItem, final int n, final long l, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, new MediaQueueItem[]{mediaQueueItem}, n, 0, 0, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, 0, -1L, mediaQueueItemArray, 0, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final GoogleApiClient googleApiClient, final int[] nArray, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, nArray, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final GoogleApiClient googleApiClient, final int[] nArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, nArray, n, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, 0, -1L, null, -1, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, 0, -1L, null, 1, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final GoogleApiClient googleApiClient, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, 0, -1L, null, 0, (Integer)n, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final GoogleApiClient googleApiClient, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzem(n) == -1) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, new int[]{n}, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(GoogleApiClient googleApiClient, int n, JSONObject jSONObject) {
        return this.queueJumpToItem(googleApiClient, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final GoogleApiClient googleApiClient, final int n, final long l, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzem(n) == -1) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, n, l, null, 0, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final GoogleApiClient googleApiClient, final int n, final int n2, final JSONObject jSONObject) {
        return googleApiClient.zzd((zzqc.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzakd;
                synchronized (object) {
                    int n4 = RemoteMediaPlayer.this.zzem(n);
                    if (n4 == -1) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    if (n2 < 0) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", n2))));
                        return;
                    }
                    if (n4 == n2) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    int n22 = n2 > n4 ? n2 + 1 : n2;
                    MediaQueueItem mediaQueueItem = RemoteMediaPlayer.this.getMediaStatus().getQueueItem(n22);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    RemoteMediaPlayer.this.lR.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.lQ.zza(this.my, new int[]{n}, n3, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.lR.zzc(null);
                    }
                }
            }
        });
    }

    private int zzem(int n) {
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.lQ.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.lQ.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.lQ.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.lQ.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener onStatusUpdatedListener) {
        this.lV = onStatusUpdatedListener;
    }

    private void onStatusUpdated() {
        if (this.lV != null) {
            this.lV.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener onMetadataUpdatedListener) {
        this.lU = onMetadataUpdatedListener;
    }

    private void onMetadataUpdated() {
        if (this.lU != null) {
            this.lU.onMetadataUpdated();
        }
    }

    public void setOnQueueStatusUpdatedListener(OnQueueStatusUpdatedListener onQueueStatusUpdatedListener) {
        this.lT = onQueueStatusUpdatedListener;
    }

    private void onQueueStatusUpdated() {
        if (this.lT != null) {
            this.lT.onQueueStatusUpdated();
        }
    }

    public void setOnPreloadStatusUpdatedListener(OnPreloadStatusUpdatedListener onPreloadStatusUpdatedListener) {
        this.lS = onPreloadStatusUpdatedListener;
    }

    private void onPreloadStatusUpdated() {
        if (this.lS != null) {
            this.lS.onPreloadStatusUpdated();
        }
    }

    public String getNamespace() {
        return this.lQ.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.lQ.zzgq(string3);
    }

    static abstract class zzb
    extends com.google.android.gms.cast.internal.zzb<MediaChannelResult> {
        zzp my = new zzp(){

            @Override
            public void zzac(long l) {
                zzb.this.zzc((MediaChannelResult)zzb.this.zzc(new Status(2103)));
            }

            @Override
            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zzc(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzq(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        protected void zza(zze zze2) {
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzq(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status fp;
        private final JSONObject lh;

        zzc(Status status, JSONObject jSONObject) {
            this.fp = status;
            this.lh = jSONObject;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public JSONObject getCustomData() {
            return this.lh;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$zza
    implements zzo {
        private GoogleApiClient mu;
        private long mv = 0L;

        public void zzc(GoogleApiClient googleApiClient) {
            this.mu = googleApiClient;
        }

        @Override
        public long zzakb() {
            return ++this.mv;
        }

        @Override
        public void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.mu == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.mu, string2, string3).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long mw;

            zza(long l) {
                this.mw = l;
            }

            public void zzp(@NonNull Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.lQ.zzb(this.mw, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        }
    }

    public static interface OnPreloadStatusUpdatedListener {
        public void onPreloadStatusUpdated();
    }

    public static interface OnQueueStatusUpdatedListener {
        public void onQueueStatusUpdated();
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

